function handleGetQuery(name) {
  var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
  var r = window.location.search.substr(1).match(reg);
  if (r != null) return unescape(r[2]);
  return null;
}

(function ($, $w) {
  //视频对象
  var videoController;

  $(document).ready(function () {
    initView();

    initVideo();
  });

  function videoListenEvent() {
    //播放后的返回事件通知
    videoController.addListener('afterclose', function (e) {});

    //分屏的返回事件通知
    videoController.addListener('screenchange', function (e) {
      $('.menu-screen>li').removeClass('on-sel');
      $('.menu-screen>li[mode=' + e.windowNums + ']').addClass('on-sel');
    });
  }

  function initVideo() {
    var url = videoPlatUrl + '/scooper-video/conf/data';
    var param = {};
    //从接口获取视频的参数信息
    $.getJSON(url, param, function (data) {
      //创建视频对象
      var conf = data;
      //参数
      var videoOpts = {
        //初始化时的界面显示的分屏树
        windows: 1,
        //共有哪几种分屏
        windowsArr: [1, 4, 9, 16],
        //总的窗口数
        windowsNum: 16,
        conf: {
          user: conf['video.username'],
          passwd: conf['video.password'],
          //videoServer ip
          // ip: conf['video.ip'],
          ip: '27.128.189.131',
          //videoServer port
          port: conf['video.port'],
          //janus地址
          // janusUrl: conf['video.janus.url']
          janusUrl: 'ws://27.128.189.131:8188',
        },
        //码流类型，默认0
        streamType: conf['video.stream'],
        //是否截屏
        capImage: conf['video.cap.image'] === 'true',
        //截屏默认保存的地址
        videoCapImagePath: conf['video.cap.image.path'],
      };
      //轮巡的时间，单位秒
      conf['video.poll.time'] && (videoOpts.pollInterval = conf['video.poll.time']);

      videoController = new scooper.video($('.video-area'), videoOpts);

      videoListenEvent();
    });
  }
  function initView() {
    //分屏切换
    $('.menu-screen>li').click(function () {
      $('.menu-screen>li').removeClass('on-sel');
      var num = $(this).addClass('on-sel').attr('mode');

      videoController.setWindowsNum(num);
    });

    //播放
    $('.btn-play').click(function () {
      var video = $('.input-devid').val();
      if (!video) {
        promptView.showAlarm('请输入视频ID');
        return;
      }

      if (videoController.isPlaying(video) != -1) {
        promptView.showAlarm('该视频正在播放！');
        return;
      }

      videoController.playByOrderExpandWindow(video, video, { name: video });
    });

    function showCam(i) {
      var camNo = [
        { name: '二甲醚球罐(二级危险源)', no: '40' },
        { name: '甲醇储罐东(四级危险源)', no: '33' },
        { name: '液氨球罐北(二级危险源)', no: '34' },
        { name: '中控室视频', no: '41' },
        { name: '液氨储罐东(二级危险源)', no: '35' },
        { name: '甲醇储罐西(四级危险源)', no: '36' },
        { name: '双氧水罐车区(三级危险源)', no: '39' },
        { name: '双氧水罐车区进口(三级危险源)', no: '37' },
        { name: '双氧水罐车区出口(三级危险源)', no: '38' },
      ];

      setTimeout(() => {
        var video = camNo[i].no;
        if (!video) {
          promptView.showAlarm('请输入视频ID');
          return;
        }
        if (videoController.isPlaying(video) != -1) {
          promptView.showAlarm('该视频正在播放！');
          return;
        }
        videoController.playByOrderExpandWindow(video, video, { name: camNo[i].name });

        if (i < camNo.length - 1) {
          showCam(++i);
        }
      }, 1000);
    }

    if (handleGetQuery('camNo')) {
      setTimeout(() => {
        var video = handleGetQuery('camNo');
        if (!video) {
          promptView.showAlarm('请输入视频ID');
          return;
        }
        if (videoController.isPlaying(video) != -1) {
          promptView.showAlarm('该视频正在播放！');
          return;
        }
        videoController.playByOrderExpandWindow(video, video, { name: decodeURIComponent(handleGetQuery('name')) });
      }, 1000);
    }else{
      showCam(0);
    }

    //停止
    $('.btn-stop').click(function () {
      var videoObj = videoController.getInChoiceVideo();

      if (!videoObj) {
        promptView.showAlarm('请选择正在播放的视频窗口！');
        return;
      }

      var index = videoController.isPlaying(videoObj.id);
      videoController.close(index);
    });

    //一键关闭
    $('.btn-stop-all').click(function () {
      videoController.closeAll();
    });

    //参数配置
    // $(".p-config").click(function () {
    //     $(".dialog-config").show();
    // });
    //
    // $('.left-switch').click(function () {
    //     $('.part-left').toggleClass('hide')
    //     $('.part-right').toggleClass('hide')
    //     $(this).toggleClass('open')
    // })
  }
})(jQuery, window);
