/*  
	引入js，css文件
	直接调用接口：
	promptView.showSuccess('派警成功');//显示绿色成功提示框(对勾)
	promptView.showFailed('呼叫失败');//显示红色失败提示框（叉）
	promptView.showAlarm('呼叫失败');//显示红色提示框（叹号）
	
	var callback = {//confirm提示框两个按钮的回调函数
	 	confirm:function(){//‘立即处理’回调
	 		console.log('confirm');
	 	},
	 	cancel:function(){//‘暂不处理’回调
	 		console.log('cancel');
	 	}
	 }
 	promptView.showConfirm('出现新警情',callback);//显示确认操作框

 	promptView.changeConfirmBtn('确认','取消');//修改confirm框两个按钮的名字
	promptView.config({//配置提示框参数，详情见源码内注释
	 	top:80,
	});

*/

(function(factory){
    if (typeof define === 'function' && define.amd)
      define(['jquery'], factory);
    else if (typeof exports === 'object')
      factory(require('jquery'));
    else
      factory(jQuery);

}(function($, undefined){
	/**
	* 为了保证css动画，提示框嵌套层级修改慎重
	*/
	if (!window.promptView) { window.promptView = (function () {
		var _index = 1000;
		var PromptView = function (){
			this.displayTime = 2000;
			this.confirmText = '确定';
			this.cancelText = '取消';
			this.top = 0;
			this.left = '';
			_index = 1000;
		};
		PromptView.prototype = {
			/**
			 * 配置提示框
			 */
			config:function(opts){
				opts = opts || {};
				this.displayTime = opts.displayTime ||this.displayTime;//alert提示框停留时间，包括0.4s淡出动画
				this.confirmText = opts.confirmText ||this.confirmText;//confirm确认按钮文字，可通过changeConfirmBtn重设
				this.cancelText = opts.cancelText || this.cancelText;//confirm取消按钮文字，可通过changeConfirmBtn重设
				this.top = opts.top || this.top;//提示框定位，默认居顶  传空字符串居中
				this.left = opts.left ||this.left;//提示框定位,默认居中
				if(opts.index && _index == 1000){
					_index = opts.index;//起始index值，未生成任何提示框前调用，否则无效
				}
			},
			/**
			* 成功提示框
			* 淡化消失动画css设定0.4秒，若修改需同步调整定时器
			*/
			showSuccess:function(text){
				var _view = '<div id = "prompt-view-' 
						+ _index 
						+ '" class = "prompt-container">'
						+ '<div class = "prompt-box prompt-succ prompt-show"><span class = "prompt-box-icon"></span>'
						+ '<span class = "prompt-box-text">' + text + '</span></div></div>';
				var self = this;
				$("body").append(_view);
				var tipBox = $('#prompt-view-' + _index);
				tipBox.css('z-index',_index);
				this._setPosition(tipBox);

				setTimeout(function() {
					tipBox.addClass("prompt-hide");
				}, self.displayTime - 400);

				setTimeout(function() {
					tipBox.remove();
				}, self.displayTime);

				_index ++;
			},
			/**
			* 失败提示框
			*/
			showFailed:function(text){
				var _view = '<div id = "prompt-view-' 
						+ _index 
						+ '" class = "prompt-container">'
						+ '<div class = "prompt-box prompt-fail prompt-show"><span class = "prompt-box-icon"></span>'
						+ '<span class = "prompt-box-text">' + text + '</span></div></div>';
				var self = this;
				$("body").append(_view);
				var tipBox = $('#prompt-view-' + _index);
				tipBox.css('z-index',_index);
				this._setPosition(tipBox);

				setTimeout(function() {
					tipBox.addClass("prompt-hide");
				}, self.displayTime - 400);

				setTimeout(function() {
					tipBox.remove();
				}, self.displayTime);

				_index ++;
			},
			/**
			* 失败提示框
			*/
			showAlarm:function(text,showClose){
				var _view = '<div id = "prompt-view-' 
					+ _index 
					+ '" class = "prompt-container">'
					+ '<div class = "prompt-box prompt-alarm prompt-show"><span class = "prompt-box-icon"></span>'
					+ '<span class = "prompt-box-text">' + text + '</span>'
					+ (showClose ? '<button class="prompt-btn-close"></button>':'') + '</div></div>';
				var self = this;
				$("body").append(_view);
				var tipBox = $('#prompt-view-' + _index);
				tipBox.css('z-index',_index);
				this._setPosition(tipBox);
	
				if(showClose){
					tipBox.find(".prompt-btn-close").click(function(){
						tipBox.remove();
					});
				}else{
					setTimeout(function() {
						tipBox.addClass("prompt-hide");
					}, self.displayTime - 400);
		
					setTimeout(function() {
						tipBox.remove();
					}, self.displayTime);
				}
	
				_index ++;
			},
			/**
			* 失败提示框
			*/
			showLoding:function(text, showMask){
				$(".lodingBox").remove();
				var _view = '<div id = "prompt-view-' 
					+ _index 
					+ '" class = "prompt-container lodingBox">'
					+ '<div class = "prompt-box prompt-loding '
					+ (showMask?'':'prompt-show') + '"><span class = "prompt-box-icon"></span>'
					+ '<span class = "prompt-box-text">' + text + '</span></div></div>';
				var self = this;
				$("body").append(_view);
				var tipBox = $('#prompt-view-' + _index);
				tipBox.css('z-index',_index);
				
				if(showMask){
					$("body").append('<div class="prompt-mask"></div>');
					$(".prompt-mask").css('z-index',_index - 1);
					tipBox.css({
						"top":$(window).height() / 2 - tipBox.height() / 2,
						"left":$(window).width() / 2 - tipBox.width() / 2
					});
					tipBox.children().css("border-radius","5px");
				}else{
					this._setPosition(tipBox);
				}
				_index ++;
			},
			hideLoding:function(){
				$(".lodingBox").remove();
				$(".prompt-mask").remove();
			},
			/**
			* confirm提示框，目前只提供确认回调
			*/
			showConfirm:function(text,callback){
				var _view = '<div class = "prompt-container confirm-height" id = "prompt-view-' + _index + '">'
				+ '<div class = "prompt-confirm prompt-show">'
				+ '<div class = "confirm-header"><span class = "prompt-box-icon"></span>'
				+ '<span class = "prompt-box-text">' + text + '</span></div>'
				+ '<div class = "confirm-footer"><button class = "confirm-btn btn-confirm">' + this.confirmText + '</button>'
				+ '<button class = "confirm-btn btn-cancel">' + this.cancelText + '</button></div>'
				+ '<div></div>';
				var self = this;
				$("body").append(_view);

				//遮罩
				if(!$(".prompt-mask").length){
					var mask = document.createElement('div');
					mask.className = 'prompt-mask';
					mask.style['z-index'] =  _index - 1;
					document.body.appendChild(mask);
				}
				
				var tipBox = $('#prompt-view-' + _index);
				tipBox.css('z-index',_index);
				this._setPosition(tipBox);
				
				tipBox.find('.btn-cancel').click(function(){
					tipBox.children().removeClass("prompt-show").addClass("prompt-slideup");
					
					setTimeout(function() {
						tipBox.remove();
						if(!$(".prompt-confirm").length){
							$(".prompt-mask").remove();
						}
					},400);
					
					if(typeof callback == 'object'){
						if(typeof callback.cancel == 'function'){
							callback.cancel();
						}
					}
				});
				tipBox.find('.btn-confirm').click(function(){
					tipBox.children().removeClass("prompt-show").addClass("prompt-slideup");
					
					setTimeout(function() {
						tipBox.remove();
						if(!$(".prompt-confirm").length){
							$(".prompt-mask").remove();
						}
					},400);

					if(typeof callback == 'object'){
						if(typeof callback.confirm == 'function'){
							callback.confirm();
						}
					}
				});

				$(mask).click(function (){
					tipBox.addClass("prompt-shining");
					setTimeout(function() {
						tipBox.removeClass("prompt-shining");
					},300);
				})
				_index ++;
			},
			/**
			* 调整confirm的按钮文字，便于复用
			*/
			changeConfirmBtn:function(textTrue,textFalse){
				if(textTrue) this.confirmText = textTrue;
				if(textFalse) this.cancelText = textFalse;
			},
			_setPosition:function(element){
				var _top = (typeof this.top == "number")?this.top : $(window).height()/2 - element.height()/2;
				element.css('top',_top);

				var _left = (typeof this.left == "number")?this.left : $(window).width()/2 - element.width()/2;
				element.css('left',_left);
			}
			
		}

		/**
		 * 保持提示框居中
		 */
		 $(window).resize(function() {
			 _resetCenter();
		 });

		 function _resetCenter() {
			var _view = $(".prompt-container");
			for(var i = 0; i < _view.length; i++){
				var _left = this.left?this.left : $(window).width()/2 - _view.eq(i).width()/2;
				_view.eq(i).css('left',_left);
			}
		 }
		
		return new PromptView();
	})(); }
}));

