/**
 * 消息通知订阅
 */
(function (window, $) {
  var _sub = {
    init: function () {
      initCometd();
    },
  };

  /**
   * 初始化cometd
   */
  function initCometd() {
    var _cometd = new org.cometd.CometD('xjInfoReport');
    _cometd.websocketEnabled = true;
    var cometdUrl = apis.scooper.cometd;

    _cometd.init({
      url: cometdUrl,
      logLevel: 'info',
    });

    _cometd.addListener('/meta/handshake', function (message) {
      if (message.successful) {
        console.log('handshake success.');
      }
    });

    var _connected = false;
    _cometd.addListener('/meta/connect', function (message) {
      if (message.successful) {
        if (!_connected) {
          doSubscribe(_cometd);
        }
        _connected = true;
      } else {
        _connected = false;
        console.log('连接cometd后台失败');
      }
    });
  }

  /**
   * 对订阅的通知进行处理
   */
  function doSubscribe(_cometd) {
    /**
     * 会场模块消息通知
     */
    _cometd.subscribe('/dispatch-web/notify/meet/#', null, function (message) {
      console.log('会场状态通知', message.data);
      //var tmp = JSON.parse(message.data.data);
      var tmp = message.data.data;
      var meetId = tmp.meetId;
      var tel = tmp.tel;

      //判断当前页面是否为该会议现场--不在则忽略该通知
      if (message.data.type == 'meetStatus') {
        if (tmp.destroy) {
          window._dispUtils._meet.initMeets();
        } else {
          $meetDom = $('#meet-' + tmp.meetId);
          if (!$meetDom || !$meetDom.length) {
            window._dispUtils._meet.initMeets();
          }
        }
      } else if (message.data.type == 'member') {
        if ($('.meet-sel').attr('meetid') == meetId) {
          if ('add' == tmp.type) {
            //会场成员--加入
            window._dispUtils._meet.drawMeetMems(meetId);
          } else if ('del' == tmp.type) {
            //会场成员--退出
            $('#' + tel + '-user-meet').remove();
          }
        }
      }
    });

    /**
     * 呼叫模块消息通知
     */
    _cometd.subscribe('/dispatch-web/notify/call/#', null, function (message) {
      console.log('号码状态通知', message.data);

      //var dataJson = JSON.parse(message.data.data);
      var dataJson = message.data.data;
      var tel = dataJson.tel;

      var text = '';
      switch (dataJson.status) {
        case 'callst_ring':
          text = '振铃中';
          break;
        case 'callst_doubletalk':
          text = '通话中';
          break;
        case 'callst_idle':
          text = '呼叫单兵';

          videoController && videoController.closeAll();
          $('.videoHome').append($('.videoHandler'));

          layer.closeAll();
          break;
        default:
          text = '呼叫中';
          break;
      }

      $(`.soldierBtn${tel}`).find('.btn-callSoldier').text(text);
      //更新号码状态缓存
      window._telStatus.setTelStatus(tel, dataJson.status);

      //判断当前页面有没有该号码
      var telStatusDesc = window._telStatus.getTelStatus(tel).statusDesc;
      $dom = $('#' + tel + '-user-status');
      if ($dom && $dom.length) {
        $dom.text(telStatusDesc);
        $dom.click();
      }
    });

    /**
     * 视频通话状态消息通知(视频通话建立 和 中断)
     */
    _cometd.subscribe('/server/#', null, function (message) {
      // console.log("配置状态通知", message.data);
      if (message.data && '/server/config' == message.data.topic) {
        var data = message.data.data;
        var dataJson = JSON.parse(data);

        var dataValue = dataJson.value;

        if ('decoder_info' == dataJson.type) {
          //解析通知内容存入valueObj对象
          var valueObj = {};
          var dataValueArr = dataValue.split(';');
          $.each(dataValueArr, function (i, value) {
            var valueArr = value.split('=');
            if (valueArr.length == 2) {
              valueObj[valueArr[0]] = valueArr[1];
            }
          });
          //console.log("可以打开视频" + valueObj["call_number"]);
          window._video.doPlay(valueObj['call_number']);
        } else if ('stop_decoder' == dataJson.type) {
          //console.log("可以关闭视频" + dataValue);
          window._video.doCloseByDevId(dataValue);
        }
      }
    });

    //'#'：多级通配，订阅所有的主题
    _cometd.subscribe('/scooper_core/#', null, function (message) {
      //树对象获取
      var addressListTree = $.fn.zTree.getZTreeObj('addressListTree');
      /**
       * 部门模块消息通知
       * 根据“topic”可以知道是哪一个主题的变化
       * 关于部门信息通知，不论是增删改，都需要重新构建树结构，所以都要执行addressListFirst();方法。
       */
      if (message.data.topic == '/scooper_core/dataChange/orgDept') {
        console.log('收到 通讯录--部门 数据通知');
        console.log(message.data);

        if (message.data.type == 'UPDATE') {
          var deptId = message.data.id;
          var node = addressListTree.getNodeByParam('id', deptId, null);
          if (!node) return;

          //根据部门ID查询部门名称
          var url = window._util.getApiCoreServer('/data/contacts/orgDeptManage/getOrgDeptDetail');
          var param = {
            id: deptId,
          };
          window._util._loadJson(url, param, function (data) {
            if (data.code == 0) {
              if (data.data) {
                node.name = data.data.deptName;
                addressListTree.updateNode(node);
              }
            } else {
              alert('获取部门成员详细信息失败，' + data.message);
            }
          });
        } else if (message.data.type == 'DELETE') {
          //根据返回的要删除的部门IDString删除节点
          var delDeptIdArr = message.data.data.split(',');

          for (var i = 0; i < delDeptIdArr.length; i++) {
            var node = addressListTree.getNodeByParam('id', delDeptIdArr[i], null);
            if (node) {
              addressListTree.removeNode(node);
            }
          }
        } else if (message.data.type == 'ADD') {
          var url = window._util.getApiCoreServer('/data/contacts/orgDeptManage/getOrgDeptDetail');
          var param = {
            id: message.data.id,
          };
          window._util._loadJson(url, param, function (data) {
            if (data.code == 0) {
              if (data.data) {
                //根据部门ID查询部门名称
                var url = window._util.getApiCoreServer('/data/contacts/orgDeptManage/getOrgDeptDetail');
                var param = {
                  id: message.data.id,
                };
                window._util._loadJson(url, param, function (data) {
                  if (data.code == 0) {
                    if (data.data) {
                      var parentNode = addressListTree.getNodeByParam('id', data.data.parentId, null);
                      if (!parentNode) {
                        console.log('新增部门的父部门节点不存在或未加载');
                      }

                      //判断该节点是否存在，如果不存在，则添加
                      var node = addressListTree.getNodeByParam('name', data.data.deptName, parentNode);
                      if (node == null) {
                        var newNode = {
                          name: data.data.deptName,
                          id: data.data.id,
                        };

                        newNode = addressListTree.addNodes(parentNode, newNode);
                      }
                    }
                  } else {
                    console.log('处理新增部门通知 --- 获取部门成员详细信息失败，' + data.message);
                  }
                });
              }
            } else {
              alert('处理新增部门通知 --- 获取部门成员详细信息失败，' + data.message);
            }
          });
        }
      }

      /**
       * 部门成员模块消息通知
       */
      //关于部门成员信息通知，当此时页面上显示的有该成员的信息时，才需要对该操作进行处理。
      if (message.data.topic == '/scooper_core/dataChange/orgMember') {
        console.log('收到 通讯录--成员 数据通知');
        console.log(message.data);

        var selectNode = addressListTree.getSelectedNodes().length ? addressListTree.getSelectedNodes()[0] : null;
        var selectDeptId = selectNode.id;
        //更新成员操作
        if (message.data.type == 'UPDATE') {
          var url = window._util.getApiCoreServer('/data/contacts/orgMemberManage/getOrgMemberDetail');
          var param = {
            id: message.data.id,
          };
          window._util._loadJson(url, param, function (data) {
            if (data.code == 0) {
              var deptId = data.data.deptId;
              var memId = data.data.id;
              var memTel = data.data.memTel;

              var $dom = $('#' + memId + '-user-id');
              if ($dom && $dom.length) {
                if (selectDeptId == deptId) {
                  $dom.find('.user-name').text(data.data.memName);
                  $dom.find('.user-tel').text(memTel);
                  var telStatus = window._telStatus.getTelStatus(memTel).statusDesc;
                  $dom.find('.user-status').text(telStatus);
                  $dom.find('.user-status').attr('id', memTel + '-user-status');
                } else {
                  $dom.remove();
                }
              } else if (selectDeptId == deptId) {
                //移动到当前部门
                window._memList.drawMemListByDeptId(selectDeptId);
              }
            } else {
              alert('获取部门成员详细信息失败，' + data.message);
            }
          });
        }
        //删除成员操作
        else if (message.data.type == 'DELETE') {
          var delMemIdArr = message.data.data.split(',');

          for (var i = 0; i < delMemIdArr.length; i++) {
            var delMemId = delMemIdArr[i];
            var $dom = $('#' + delMemId + '-user-id');
            if ($dom && $dom.length) {
              $dom.remove();
            }
          }
        }
        //新增成员操作
        else if (message.data.type == 'ADD') {
          var url = window._util.getApiCoreServer('/data/contacts/orgMemberManage/getOrgMemberDetail');
          var param = {
            id: message.data.id,
          };
          window._util._loadJson(url, param, function (data) {
            if (data.code == 0) {
              if (selectDeptId == data.data.deptId) {
                window._memList.drawMemListByDeptId(selectDeptId);
              }
            } else {
              alert('获取部门成员详细信息失败，' + data.message);
            }
          });
        }
      }
    });
  }

  window._sub = _sub;
})(window, $);
