import Vue from 'vue'
import VueRouter from 'vue-router'
import Layout from '../views/Layout/index.vue'
import METHOD from '../utils/methods'
import stroe from '../store'
import store from '../store'

Vue.use(VueRouter)

//自定义 为了是外部可以访问
/**
 * 包含children的为左侧显示菜单，hidden来根据权限控制显示与否
*/
const baseRouterMap = [
  {
    path: '/',
    name: 'index',
    redirect: '/login'
  },
  {
    path: '/subReport',
    name: 'subReport',
    hidden: true,
    component: () => import('@/views/SubReport.vue')
  },
  {
    path: '/login',
    name: 'Login',
    hidden: true,
    component: () => import('@/views/Login.vue')
  },
  {
    path: '/alls',
    name: 'entrys',
    component: () => import('@/views/All.vue')
  },
  {
    path: '/404',
    name: '404',
    hidden: true,
    component: () => import('@/views/404.vue')
  },
  {
    path: '*', redirect: '/404', hidden: true,
  }
];
const defalutRouterMap = [
  {
    path: '/',
    name: 'index',
    redirect: '/login'
  },
  {
    path: '/login',
    name: 'Login',
    hidden: true,
    component: () => import('@/views/Login.vue')
  },
  {
    path: '/alls',
    name: 'entrys',
    component: () => import('@/views/All.vue')
  },
  {
      path: '/subReport',
      name: 'subReport',
      hidden: true,
      component: () => import('@/views/SubReport.vue')
  },
  {
    path: '/404',
    name: '404',
    hidden: true,
    component: () => import('@/views/404.vue')
  },
  {
    path: '*', redirect: '/404', hidden: true,
  },
  {
    path: '/sjjb',
    component: Layout,
    redirect: '/EventsMg',
    meta: {
      title: '事件接报',
      id: 1
    },
    children: [
      {
        path: '/EventsMg',
        name: 'EventsMg',
        meta: {
          title: '事件接报',
          icon: 'iconfont iconyangan',
          id: 11
        },
        component: () => import('@/views/Main/Duty/EventsMg.vue')
      },
        {
            path: '/EventsInfo',
            name: 'EventsInfo',
            meta: {
                title: '报送信息',
                icon: 'iconfont iconyonghu',
                id: 12
            },
            component: () => import('@/views/Main/Duty/EventsInfo.vue')
        }
    ]
  },
  {
    path: '/yjyl',
    component: Layout,
    redirect: '/EventsMg',
    meta: {
      title: '应急演练',
      id: 1
    },
    children: [
      {
        path: '/DrillMg',
        name: 'DrillMg',
        meta: {
          title: '应急演练',
          icon: 'iconfont iconicon-',
          id: 12
        },
        component: () => import('@/views/Main/Duty/DrillMg.vue')
      }
    ]
  },
  {
    path: '/yjzhs',
    component: Layout,
    redirect: '/MembersMg',
    meta: {
      title: '应急值守',
      id: 2
    },
    children: [
      {
        path: '/MembersMg',
        name: 'MembersMg',
        meta: {
          title: '通讯录',
          icon: 'iconfont iconuser',
          id: 21
        },
        component: () => import('@/views/Main/Duty/MembersMg.vue')
      },
      {
        path: '/BookPlan',
        name: 'BookPlan',
        meta: {
          title: '值班安排',
          icon: 'iconfont iconicon',
          id: 22
        },
        component: () => import('@/views/Main/Duty/BookPlan.vue')
      },
	  {
	    path: '/BookPlanDown',
	    name: 'BookPlanDown',
	    meta: {
	      title: '值班日志',
	      icon: 'iconfont iconrizhi',
	      id: 23
	    },
	    component: () => import('@/views/Main/Duty/BookPlanDown.vue')
	  },
    ]
  },
  {
    path: '/sjcz',
    component: Layout,
    redirect: '/ProcessEvents',
    meta: {
      title: '事件处置',
      id: 3
    },
    children: [
      {
        path: '/ProcessEvents',
        name: 'ProcessEvents',
        meta: {
          title: '事件处置',
          icon: 'iconfont iconziyuan',
          id: 31
        },
        component: () => import('@/views/Main/Duty/ProcessEvents.vue')
      }
    ]
  },
  {
    path: '/szya',
    component: Layout,
    redirect: '/PlansMg',
    meta: {
      title: '数字预案',
      id: 4
    },
    children: [
      {
        path: '/PlansMg',
        name: 'PlansMg',
        meta: {
          title: '预案管理',
          icon: 'iconfont iconicon',
          id: 41
        },
        component: () => import('@/views/Main/Duty/PlansMg.vue')
      }
    ]
  },
  {
    path: '/wzbz',
    component: Layout,
    redirect: '/SocilDeivcMg',
    meta: {
      title: '物资保障',
      id: 5
    },
    children: [
      {
        path: '/SocilDeivcMg',
        name: 'SocilDeivcMg',
        meta: {
          title: '应急保障',
          icon: 'iconfont iconxiaofang',
          listId: '5693013f8bb14a44abdc6faa6df212cc',
          id: 51
        },
        component: () => import('@/views/Main/Ioc/SocilDeivcMg.vue')
      }
    ]
  },
  {
    path: '/jcxx',
    component: Layout,
    redirect: '/UserMg',
    meta: {
      title: '基础信息',
      id: 6
    },
    children: [
      {
        path: '/UserMg',
        name: 'UserMg',
        meta: {
          title: '用户管理',
          icon: 'iconfont iconbumen',
          id: 61
        },
        component: () => import('@/views/Main/User/UserMg.vue')
      },
      {
        path: '/RoleMg',
        name: 'RoleMg',
        meta: {
          title: '角色管理',
          icon: 'iconfont iconyonghu',
          id: 62
        },
        component: () => import('@/views/Main/User/RoleMg.vue')
      },
      {
        path: '/BranchMg',
        name: 'BranchMg',
        meta: {
          title: '组织机构',
          icon: 'iconfont iconbumen2',
          id: 63
        },
        component: () => import('@/views/Main/User/BranchMg.vue')
      },
      {
        path: '/MenuMg',
        name: 'MenuMg',
        meta: {
          title: '菜单管理',
          icon: 'iconfont iconshezhi',
          id: 64
        },
        component: () => import('@/views/Main/User/MenuMg.vue')
      },
      {
        path: '/APIMg',
        name: 'APIMg',
        meta: {
          title: 'API管理',
          icon: 'iconfont iconzidianguanli',
          id: 65
        },
        component: () => import('@/views/Main/User/APIMg.vue')
      },
      {
        path: '/KnowledgeInfo',
        name: 'KnowledgeInfo',
        meta: {
          title: '安全隐患信息',
          icon: 'iconfont iconrizhi',
          id: 66
        },
        component: () => import('@/views/Main/User/KnowledgeInfo.vue')
      },
      {
          path: '/Report',
          name: 'Report',
          meta: {
              title: '报送模板',
              icon: 'iconfont iconzidianguanli',
              id: 67
          },
          component: () => import('@/views/Main/User/Report.vue')
      },
    ]
  },
  {
    path: '/sbgl',
    component: Layout,
    redirect: '/SignsMg',
    meta: {
      title: '综合保障',
      id: 7
    },
    children: [
      {
        path: '/SignsMg',
        name: 'SignsMg',
        meta: {
          title: '图例管理',
          icon: 'iconfont icontuli',
          id: 71
        },
        component: () => import('@/views/Main/Ioc/SignsMg.vue')
      },
      {
        path: '/CamerasMg',
        name: 'CamerasMg',
        meta: {
          title: '视频监控',
          icon: 'iconfont iconshexiangtou',
          listId: '35ee3dd02b2b4412b012f97480902afc',
          id: 72
        },
        component: () => import('@/views/Main/Ioc/CamerasMg.vue')
      },
      // {
      //   path: '/PublicDivceMg',
      //   name: 'PublicDivceMg',
      //   meta: {
      //     title: '公共设施',
      //     icon: 'iconfont iconicon',
      //     listId: 'aasd5152345fhlliewrwqeipuroiw444444',
      //     id: 73
      //   },
      //   component: () => import('@/views/Main/Ioc/PublicDivceMg.vue')
      // },
      {
        path: '/CompanyMg',
        name: 'CompanyMg',
        meta: {
          title: '安全生产企业',
          icon: 'iconfont iconqiye',
          listId: 'c2a853d6d12846fe81f8ce23b7683c11',
          id: 73
        },
        component: () => import('@/views/Main/Ioc/CompanyMg.vue')
      },
      // {
      //   path: '/GasMg',
      //   name: 'GasMg',
      //   meta: {
      //     title: '煤改气',
      //     icon: 'iconfont iconranqizao',
      //     listId: 'e1939da1dde440f48e28f4b106ea0b4a',
      //     id: 75
      //   },
      //   component: () => import('@/views/Main/Ioc/GasMg.vue')
      // },
      // {
      //   path: '/FireMg',
      //   name: 'FireMg',
      //   meta: {
      //     title: '重点防火单位',
      //     icon: 'iconfont iconhuo',
      //     listId: '058568906b6b4407bc76539a3b567761',
      //     id: 76
      //   },
      //   component: () => import('@/views/Main/Ioc/FireMg.vue')
      // },
      {
        path: '/NaturalMg',
        name: 'NaturalMg',
        meta: {
          title: '自然灾害',
          icon: 'iconfont iconicon-',
          listId: '1vbnm62345b6b8765bc12349a3wsx776',
          id: 74
        },
        component: () => import('@/views/Main/Ioc/NaturalMg.vue')
      },
      // {
      //   path: '/EmergencySpecialistMg',
      //   name: 'EmergencySpecialistMg',
      //   meta: {
      //       title: '应急专家管理',
      //       icon: 'iconfont icondanbing-xiankuang',
      //       listId: '0f526afc0ab64ff288da69374198d8a5',
      //       id: 75
      //   },
      //   component: () => import('@/views/Main/Ioc/EmergencySpecialistMg.vue')
      // },
      {
        path: '/HealthCareMg',
        name: 'HealthCareMg',
        meta: {
            title: '应急保障',
            icon: 'iconfont icondanbing-xiankuang',
            listId: '5693013f8bb14a44abdc6faa6df212cc',
            id: 75
        },
        component: () => import('@/views/Main/Ioc/HealthCareMg.vue')
      },
      // {
      //   path: '/CommunicationMg',
      //   name: 'CommunicationMg',
      //   meta: {
      //       title: '通讯保障管理',
      //       icon: 'iconfont icondanbing-xiankuang',
      //       listId: '36789f1a8dc54bacb12fc1fc45f4a673',
      //       id: 77
      //   },
      //   component: () => import('@/views/Main/Ioc/CommunicationMg.vue')
      // },
      // {
      //   path: '/TransportationResourcesMg',
      //   name: 'TransportationResourcesMg',
      //   meta: {
      //       title: '运输资源管理',
      //       icon: 'iconfont icondanbing-xiankuang',
      //       listId: '36789f1a8dc54bacb12fc1fc45f4a673',
      //       id: 78
      //   },
      //   component: () => import('@/views/Main/Ioc/TransportationResourcesMg.vue')
      // },
      // {
      //   path: '/EmergencyTeamMg',
      //   name: 'EmergencyTeamMg',
      //   meta: {
      //     title: '救援队伍管理',
      //     icon: 'iconfont icondanbing-xiankuang',
      //     listId: 'fd4d07ef8b9d42eda8fa874f16f65e00',
      //     id: 79
      //   },
      //   component: () => import('@/views/Main/Ioc/EmergencyTeamMg.vue')
      // },
      {
        path: '/EmergencyMaterialsMg',
        name: 'EmergencyMaterialsMg',
        meta: {
          title: '应急物资',
          icon: 'iconfont icondanbing-xiankuang',
          listId: 'e2345678hdsfhsafhlkdsaf93393333333',
          id: 76
        },
        component: () => import('@/views/Main/Ioc/EmergencyMaterialsMg.vue')
      },
      // {
      //   path: '/ShelterMg',
      //   name: 'ShelterMg',
      //   meta: {
      //     title: '避难场所管理',
      //     icon: 'iconfont icondanbing-xiankuang',
      //     listId: 'fd4d07ef8b9d42eda8fa874f16f65e00',
      //     id: 81
      //   },
      //   component: () => import('@/views/Main/Ioc/ShelterMg.vue')
      // },
      {
        path: '/DeviceMg',
        name: 'DeviceMg',
        meta: {
          title: '移动设备',
          icon: 'iconfont icondanbing-xiankuang',
          listId: '3a847cd06c1c432e979792986b14f4e1',
          id: 77
        },
        component: () => import('@/views/Main/Ioc/DeviceMg.vue')
      },
    ]
  },
  {
      path: '/yjczfa',
      component: Layout,
      redirect: '/DealwithNecessary',
      meta: {
          title: '应急处置方案',
          id: 1
      },
      children: [
          {
              path: '/DealwithNecessary',
              name: 'DealwithNecessary',
              meta: {
                  title: '应急处置方案',
                  icon: 'iconfont icon18',
                  id: 11
              },
              component: () => import('@/views/Main/Duty/DealwithNecessary.vue')
          }
      ]
  },
]

// export const asyncRouterMap = getRouterMap()
export let asyncRouterMap = baseRouterMap;

export const createrouter = (routes: any) => new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes: routes
});
const router = createrouter( getAsyncRouterMap() );

function getAsyncRouterMap() {
  const isLogin = sessionStorage.getItem('token');
  if (isLogin) {
    return updateRouter()
  } else {
    return asyncRouterMap
  }
}
//获取本地存储路由
function updateRouter() {
  let moudleArr = sessionStorage.getItem("moudleArr"), moudle;
  if (moudleArr) {
    moudle = JSON.parse(moudleArr);
    moudle.forEach((ele: any) => {
      ele.component = Layout;
      if (ele.children.length > 0) {
        ele.children.forEach((sele: any) => {
          let vueurl =
            (METHOD.componentUrl as any)[sele.path.replace("/", "")] +
            sele.path;
          sele.component = () => import(`@/views/Main/${vueurl}.vue`);
        });
      }
    });
    (METHOD as any).titleArray = [...moudle];
    store.dispatch('setMoudleArr', moudle)
    return [...baseRouterMap, ...moudle]
  }
}


//路由跳转前 验证登录
router.beforeEach((to: any, from: any, next: any) => {
  const isLogin = sessionStorage.getItem('token') ? true : false;
  if (to.path == '/login') {
    let userInfo = sessionStorage.getItem("userInfo"),
      token = sessionStorage.getItem("token"),
      moudleArr = sessionStorage.getItem("moudleArr");
    if (userInfo) sessionStorage.removeItem("userInfo");
    if (token) sessionStorage.removeItem("token");
    if (moudleArr) sessionStorage.removeItem("moudleArr");
    next()
  } else {
    if(to.path != '/subReport'){
        //访问其他页面先看是否有登录后存储数据
        isLogin ? next() : next('/login')
    }else {
      next()
    }
  }
})



export default router