import Vue from 'vue'
import App from './App.vue'
import store from './store'
import router from './router'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import axios from './utils/http'
import VueAMap from 'vue-amap';
import METHOD from './utils/methods'
import Layout from './views/Layout/index.vue';


Vue.use(ElementUI)

Vue.use(VueAMap)

VueAMap.initAMapApiLoader({
  key: 'c9e461c3b9bb660739ab7d11bf766bac',
  plugin: ['AMap.Autocomplete', 'AMap.PlaceSearch', 'AMap.Scale', 'AMap.OverView', 'AMap.ToolBar', 'AMap.MapType', 'AMap.PolyEditor', 'AMap.CircleEditor'],
  // 默认高德 sdk 版本为 1.4.4
  v: '1.4.4'
});

Vue.config.productionTip = false;

Vue.prototype.$axios = axios;

Vue.prototype.$toPush = function toPush(url: string, selected: any) {
  if (url == '/none') {
    this.$message.warning('功能开发中,敬请期待.....')
    return;
  } else if (selected == 'false') {
    this.$message.warning('无权限访问该功能~')
    return;
  }
  this.$router.push(url)
}


// Vue.prototype.$updateRouter = function () {
//   let getModuleArr = store.getters.moudleArr;
//   let moudleArr = localStorage.getItem('moudleArr'), componentUrl = METHOD.componentUrl;
//   if (getModuleArr.length == 0 && moudleArr) {
//     let moudle = JSON.parse(moudleArr);
//     moudle.forEach((ele: any) => {
//       ele.component = Layout;
//       if (ele.children.length > 0) {
//         ele.children.forEach((sele: any) => {
//           sele.component = () => import(`@/views/Main/${(componentUrl as any)[sele.name]}.vue`)
//         })
//       }
//     });
//     (METHOD as any).titleArray = [...moudle];
//     router.addRoutes(moudle);
//     store.dispatch('setMoudleArr', moudle);
//   } else {
//     (METHOD as any).titleArray = [...getModuleArr];
//   }
// }

var vm = new Vue({
    store,
  router,

  render: h => h(App)
}).$mount('#app');

// (vm as any).$updateRouter()