import request from '@/utils/request'

// 查询培训管理列表
export function listManage(query) {
  return request({
    url: '/train/manage/list',
    method: 'get',
    params: query
  })
}

// 查询培训管理详细
export function getManage(trainManageId) {
  return request({
    url: '/train/manage/' + trainManageId,
    method: 'get'
  })
}

// 新增培训管理
export function addManage(data) {
  return request({
    url: '/train/manage',
    method: 'post',
    data: data
  })
}

// 修改培训管理
export function updateManage(data) {
  return request({
    url: '/train/manage',
    method: 'put',
    data: data
  })
}

// 删除培训管理
export function delManage(trainManageId) {
  return request({
    url: '/train/manage/' + trainManageId,
    method: 'delete'
  })
}

// 导出培训管理
export function exportManage(query) {
  return request({
    url: '/train/manage/export',
    method: 'get',
    params: query
  })
}

//根据培训人员查询培训信息
export function getTrainInfoByPersonId(query) {
  return request({
    url: '/train/manage/getTrainInfoByPersonId',
    method: 'get',
    params: query
  })
}

//更新培训人信息
export function updatePersonInfo(data) {
  return request({
    url: '/train/person',
    method: 'put',
    data: data
  })
}
