import request from '@/utils/request'

// 查询巡检签到列表
export function listIn(query) {
  return request({
    url: '/system/in/list',
    method: 'get',
    params: query
  })
}

// 查询巡检签到详细
export function getIn(checkInId) {
  return request({
    url: '/system/in/' + checkInId,
    method: 'get'
  })
}

// 新增巡检签到
export function addIn(data) {
  return request({
    url: '/system/in',
    method: 'post',
    data: data
  })
}

// 修改巡检签到
export function updateIn(data) {
  return request({
    url: '/system/in',
    method: 'put',
    data: data
  })
}

// 删除巡检签到
export function delIn(checkInId) {
  return request({
    url: '/system/in/' + checkInId,
    method: 'delete'
  })
}

// 导出巡检签到
export function exportIn(query) {
  return request({
    url: '/system/in/export',
    method: 'get',
    params: query
  })
}