import request from '@/utils/request'

// 查询监督检查-检查范围列表
export function listInfor(query) {
  return request({
    url: '/supervision/scope/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-检查范围详细
export function getInfor(fScopeInforId) {
  return request({
    url: '/supervision/scope/' + fScopeInforId,
    method: 'get'
  })
}

// 新增监督检查-检查范围
export function addInfor(data) {
  return request({
    url: '/supervision/scope',
    method: 'post',
    data: data
  })
}

// 修改监督检查-检查范围
export function updateInfor(data) {
  return request({
    url: '/supervision/scope',
    method: 'put',
    data: data
  })
}

// 删除监督检查-检查范围
export function delInfor(fScopeInforId) {
  return request({
    url: '/supervision/scope/' + fScopeInforId,
    method: 'delete'
  })
}

// 导出监督检查-检查范围
export function exportInfor(query) {
  return request({
    url: '/supervision/scope/export',
    method: 'get',
    params: query
  })
}
