import request from '@/utils/request'

// 查询用户加装安全装置台账列表
export function listEquipment(query) {
  return request({
    url: '/standingBook/equipment/list',
    method: 'get',
    params: query
  })
}
export function getCounts() {
  return request({
    url: '/standingBook/equipment/selectCountByYears',
    method: 'get',
  })
}

export function selectCountByUserType() {
  return request({
    url: '/standingBook/equipment/selectCountByUserType',
    method: 'get',
  })
}
// 查询用户加装安全装置台账详细
export function getEquipment(safeEquipmentId) {
  return request({
    url: '/standingBook/equipment/' + safeEquipmentId,
    method: 'get'
  })
}

// 新增用户加装安全装置台账
export function addEquipment(data) {
  return request({
    url: '/standingBook/equipment',
    method: 'post',
    data: data
  })
}

// 修改用户加装安全装置台账
export function updateEquipment(data) {
  return request({
    url: '/standingBook/equipment',
    method: 'put',
    data: data
  })
}

// 删除用户加装安全装置台账
export function delEquipment(safeEquipmentId) {
  return request({
    url: '/standingBook/equipment/' + safeEquipmentId,
    method: 'delete'
  })
}

// 导出用户加装安全装置台账
export function exportEquipment(query) {
  return request({
    url: '/standingBook/equipment/export',
    method: 'get',
    params: query
  })
}
