import request from '@/utils/request'

// 查询行业专家库-专家库浏览列表
export function listBrowse(query) {
  return request({
    url: '/specialist/browse/list',
    method: 'get',
    params: query
  })
}

// 查询行业专家库-专家库浏览详细
export function getBrowse(fProAppInforId) {
  return request({
    url: '/specialist/browse/' + fProAppInforId,
    method: 'get'
  })
}

// 新增行业专家库-专家库浏览
export function addBrowse(data) {
  return request({
    url: '/specialist/browse',
    method: 'post',
    data: data
  })
}

// 修改行业专家库-专家库浏览
export function updateBrowse(data) {
  return request({
    url: '/specialist/browse',
    method: 'put',
    data: data
  })
}

// 删除行业专家库-专家库浏览
export function delBrowse(fProAppInforId) {
  return request({
    url: '/specialist/browse/' + fProAppInforId,
    method: 'delete'
  })
}

// 导出行业专家库-专家库浏览
export function exportBrowse(query) {
  return request({
    url: '/specialist/browse/export',
    method: 'get',
    params: query
  })
}

//获取任务
export function getExpertDeclarationTask(query) {
  return request({
    url: '/government/supervision/getProfessorInfo',
    method: 'get',
    params: query
  })
}
