import request from '@/utils/request';
import qs from 'qs'
// 查询从业人员信息列表
export function listInfo(query) {
  return request({
    url: '/regulation/supervise/list',
    method: 'get',
    params: query
  })
}



export function employedPeoplesList(query){
  return request({
    url: '/regulation/supervise/employedPeoplesList',
    method: 'get',
    params: query
  })
}

// 查询从业人员信息详细
export function getInfo(employedPeopleId) {
  return request({
    url: '/regulation/supervise/' + employedPeopleId,
    method: 'get'
  })
}

// 新增从业人员信息
export function addInfo(data) {
  return request({
    url: '/regulation/supervise',
    method: 'post',
    data: data,
  })
}
//传图片
export function  addFile(file){
  return request({
    url: '/regulation/supervise/addParent',
    method: 'post',
    data: file,
    headers: {
      'Content-type': 'multipart/form-data'
    },
  })
}

// 修改从业人员信息
export function updateInfo(data) {
  return request({
    url: '/regulation/supervise',
    method: 'put',
    data: data
  })
}

// 删除从业人员信息
export function delInfo(employedPeopleId) {
  return request({
    url: '/regulation/supervise/' + employedPeopleId,
    method: 'delete'
  })
}

// 导出从业人员信息
export function exportInfo(query) {
  return request({
    url: '/regulation/supervise/export',
    method: 'get',
    params: query
  })
}

// 企业信息查询(下拉框)
export function selectTEnterprise() {
    return request({
      url: '/regulation/supervise/selectTEnterprise',
      method: 'get'
    })
  }



// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/regulation/supervise/importTemplate',
    method: 'get'
  })
}



// 下载用户导入模板
export function countImportError() {
  return request({
    url: '/regulation/supervise/countImportError',
    method: 'get'
  })
}


// 导出从业人员信息- 错误数据
export function importErrorexportInfo() {
  return request({
    url: '/supervise/error/export',
    method: 'get'
  })
}

// 导出从业人员信息- 错误数据
export function clearImportError() {
  return request({
    url: '/supervise/error/clearImportError',
    method: 'get'
  })
}



// 导出从业人员信息- 错误数据
export function queryPeopleOccupationByGroupBy() {
  return request({
    url: '/regulation/supervise/queryPeopleOccupationByGroupBy',
    method: 'get'
  })
}
