import request from '@/utils/request'

// 查询燃气车辆位置信息列表
export function listInfo(query) {
  return request({
    url: '/system/vehicleLocationInfo/list',
    method: 'get',
    params: query
  })
}

//获取车辆位置信息
export function getVehicleLocations(query){
  return request({
    url: '/system/vehicleLocationInfo/getVehicleLocations',
    method: 'get',
    params: query
  })
}

// 查询燃气车辆位置信息详细
export function getInfo(vehicleLocationId) {
  return request({
    url: '/system/vehicleLocationInfo/' + vehicleLocationId,
    method: 'get'
  })
}

// 新增燃气车辆位置信息
export function addInfo(data) {
  return request({
    url: '/system/vehicleLocationInfo',
    method: 'post',
    data: data
  })
}

// 修改燃气车辆位置信息
export function updateInfo(data) {
  return request({
    url: '/system/vehicleLocationInfo',
    method: 'put',
    data: data
  })
}

// 删除燃气车辆位置信息
export function delInfo(vehicleLocationId) {
  return request({
    url: '/system/vehicleLocationInfo/' + vehicleLocationId,
    method: 'delete'
  })
}

// 导出燃气车辆位置信息
export function exportInfo(query) {
  return request({
    url: '/system/vehicleLocationInfo/export',
    method: 'get',
    params: query
  })
}
