import request from '@/utils/request'

// 查询燃气任务列表
export function listOrder(query) {
  return request({
    url: '/system/order/list',
    method: 'get',
    params: query
  })
}
export function orderCount(query) {
  return request({
    url: '/system/order/listCount',
    method: 'get',
    params: query
  })
}

// 查询燃气任务详细
export function getOrder(workId) {
  return request({
    url: '/system/order/' + workId,
    method: 'get'
  })
}

// 新增燃气任务
export function addOrder(data) {
  return request({
    url: '/system/order',
    method: 'post',
    data: data
  })
}

// 修改燃气任务
export function updateOrder(data) {
  return request({
    url: '/system/order',
    method: 'put',
    data: data
  })
}

// 删除燃气任务
export function delOrder(workId) {
  return request({
    url: '/system/order/' + workId,
    method: 'delete'
  })
}

// 导出燃气任务
export function exportOrder(query) {
  return request({
    url: '/system/order/export',
    method: 'get',
    params: query
  })
}

export function selectWorkOrderNum(query) {
  return request({
    url: '/system/order/selectWorkOrderNum',
    method: 'get',
    params: query
  })
}
