import request from '@/utils/request'

// 查询老旧管网-改造计划和进度列表
export function listProcess(query) {
  return request({
    url: '/oldPipeSystem/plan/list',
    method: 'get',
    params: query
  })
}

// 查询老旧管网-改造计划和进度详细
export function getProcess(fOldPlanProcessId) {
  return request({
    url: '/oldPipeSystem/plan/' + fOldPlanProcessId,
    method: 'get'
  })
}

// 新增老旧管网-改造计划和进度
export function addProcess(data) {
  return request({
    url: '/oldPipeSystem/plan',
    method: 'post',
    data: data
  })
}

// 修改老旧管网-改造计划和进度
export function updateProcess(data) {
  return request({
    url: '/oldPipeSystem/plan',
    method: 'put',
    data: data
  })
}

// 删除老旧管网-改造计划和进度
export function delProcess(fOldPlanProcessId) {
  return request({
    url: '/oldPipeSystem/plan/' + fOldPlanProcessId,
    method: 'delete'
  })
}

// 导出老旧管网-改造计划和进度
export function exportProcess(query) {
  return request({
    url: '/oldPipeSystem/plan/export',
    method: 'get',
    params: query
  })
}

// 企业端上传 老旧官网
export function entReportPipeOldPlanProcess(query) {
  return request({
    url: '/oldPipeSystem/plan/entReportPipeOldPlanProcess',
    method: 'get',
    params: query
  })
}

// 政府端上传 老旧官网
export function reportPipeOldPlanProcess(query) {
  return request({
    url: '/oldPipeSystem/plan/reportPipeOldPlanProcess',
    method: 'get',
    params: query
  })
}