import request from '@/utils/request'

// 查询消息列表
export function listInfo(query) {
  return request({
    url: '/message/info/list',
    method: 'get',
    params: query
  })
}

// 查询消息详细
export function getInfo(messageId) {
  return request({
    url: '/message/info/' + messageId,
    method: 'get'
  })
}

// 新增消息
export function addInfo(data) {
  return request({
    url: '/message/info',
    method: 'post',
    data: data
  })
}

// 修改消息
export function updateInfo(data) {
  return request({
    url: '/message/info',
    method: 'put',
    data: data
  })
}

// 删除消息
export function delInfo(messageId) {
  return request({
    url: '/message/info/' + messageId,
    method: 'delete'
  })
}

// 导出消息
export function exportInfo(query) {
  return request({
    url: '/message/info/export',
    method: 'get',
    params: query
  })
}
