import request from '@/utils/request'

// 查询液化石油气-充装记录列表
export function listFiles(query) {
  return request({
    url: '/lpg/airchargefiles/list',
    method: 'get',
    params: query
  })
}

// 查询液化石油气-充装记录详细
export function getFiles(fGasAirChargeId) {
  return request({
    url: '/lpg/airchargefiles/' + fGasAirChargeId,
    method: 'get'
  })
}

// 新增液化石油气-充装记录
export function addFiles(data) {
  return request({
    url: '/lpg/airchargefiles',
    method: 'post',
    data: data
  })
}

// 修改液化石油气-充装记录
export function updateFiles(data) {
  return request({
    url: '/lpg/airchargefiles',
    method: 'put',
    data: data
  })
}

// 删除液化石油气-充装记录
export function delFiles(fGasAirChargeId) {
  return request({
    url: '/lpg/airchargefiles/' + fGasAirChargeId,
    method: 'delete'
  })
}

// 导出液化石油气-充装记录
export function exportFiles(query) {
  return request({
    url: '/lpg/airchargefiles/export',
    method: 'get',
    params: query
  })
}

// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/lpg/airchargefiles/importTemplate',
    method: 'get'
  })
}