import request from '@/utils/request'

// 查询储配站信息列表
export function listInfo(query) {
  return request({
    url: '/gasBottleTrack/storageStationManage/list',
    method: 'get',
    params: query
  })
}

export function gasStorageStationList(query) {
  return request({
    url: '/gasBottleTrack/storageStationManage/gasStorageStationList',
    method: 'get',
    params: query
  })
}

// 查询储配站信息详细
export function getInfo(stationId) {
  return request({
    url: '/gasBottleTrack/storageStationManage/' + stationId,
    method: 'get'
  })
}

// 新增储配站信息
export function addInfo(data) {
  return request({
    url: '/gasBottleTrack/storageStationManage',
    method: 'post',
    data: data
  })
}

// 修改储配站信息
export function updateInfo(data) {
  return request({
    url: '/gasBottleTrack/storageStationManage',
    method: 'put',
    data: data
  })
}

// 删除储配站信息
export function delInfo(stationId) {
  return request({
    url: '/gasBottleTrack/storageStationManage/' + stationId,
    method: 'delete'
  })
}

// 导出储配站信息
export function exportInfo(query) {
  return request({
    url: '/gasBottleTrack/storageStationManage/export',
    method: 'get',
    params: query
  })
}

// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/gasBottleTrack/storageStationManage/importTemplate',
    method: 'get'
  })
}

//基础信息统计
export function baseInfoStatistics(query) {
  return request({
    url: '/gasBottleTrack/storageStationManage/baseInfoStatistics',
    method: 'get',
    params: query
  })
}

//基础信息统计导出
export function baseInfoStatisticsExport(query) {
  return request({
    url: '/gasBottleTrack/storageStationManage/baseInfoStatisticsExport',
    method: 'get',
    params: query
  })
}
