import request from '@/utils/request'

// 查询村级行政区列表
export function listRegion(query) {
  return request({
    url: '/area/village/list',
    method: 'get',
    params: query
  })
}

// 查询村级行政区详细
export function getRegion(fId) {
  return request({
    url: '/area/village/' + fId,
    method: 'get'
  })
}

// 新增村级行政区
export function addRegion(data) {
  return request({
    url: '/area/village',
    method: 'post',
    data: data
  })
}

// 修改村级行政区
export function updateRegion(data) {
  return request({
    url: '/area/village',
    method: 'put',
    data: data
  })
}

// 删除村级行政区
export function delRegion(fId) {
  return request({
    url: '/area/village/' + fId,
    method: 'delete'
  })
}

// 导出村级行政区
export function exportRegion(query) {
  return request({
    url: '/area/village/export',
    method: 'get',
    params: query
  })
}
