package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TYehuaqiuserSafetyDeviceInfoMapper;
import com.zehong.system.domain.TYehuaqiuserSafetyDeviceInfo;
import com.zehong.system.service.ITYehuaqiuserSafetyDeviceInfoService;

/**
 * 液化石油气监管-液化气用户-安全装置加装维护Service业务层处理
 * 
 * @author zehong
 * @date 2024-09-09
 */
@Service
public class TYehuaqiuserSafetyDeviceInfoServiceImpl implements ITYehuaqiuserSafetyDeviceInfoService 
{
    @Autowired
    private TYehuaqiuserSafetyDeviceInfoMapper tYehuaqiuserSafetyDeviceInfoMapper;

    /**
     * 查询液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param fSafetyDeviceId 液化石油气监管-液化气用户-安全装置加装维护ID
     * @return 液化石油气监管-液化气用户-安全装置加装维护
     */
    @Override
    public TYehuaqiuserSafetyDeviceInfo selectTYehuaqiuserSafetyDeviceInfoById(Long fSafetyDeviceId)
    {
        return tYehuaqiuserSafetyDeviceInfoMapper.selectTYehuaqiuserSafetyDeviceInfoById(fSafetyDeviceId);
    }

    @Override
    public List<TYehuaqiuserSafetyDeviceInfo> queryDeviceInfoByUserId(Long userId) {
        return tYehuaqiuserSafetyDeviceInfoMapper.queryDeviceInfoByUserId(userId);
    }

    /**
     * 查询液化石油气监管-液化气用户-安全装置加装维护列表
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 液化石油气监管-液化气用户-安全装置加装维护
     */
    @Override
    public List<TYehuaqiuserSafetyDeviceInfo> selectTYehuaqiuserSafetyDeviceInfoList(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo)
    {
        return tYehuaqiuserSafetyDeviceInfoMapper.selectTYehuaqiuserSafetyDeviceInfoList(tYehuaqiuserSafetyDeviceInfo);
    }

    /**
     * 新增液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 结果
     */
    @Override
    public int insertTYehuaqiuserSafetyDeviceInfo(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo)
    {
        return tYehuaqiuserSafetyDeviceInfoMapper.insertTYehuaqiuserSafetyDeviceInfo(tYehuaqiuserSafetyDeviceInfo);
    }

    /**
     * 修改液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 结果
     */
    @Override
    public int updateTYehuaqiuserSafetyDeviceInfo(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo)
    {
        return tYehuaqiuserSafetyDeviceInfoMapper.updateTYehuaqiuserSafetyDeviceInfo(tYehuaqiuserSafetyDeviceInfo);
    }

    /**
     * 批量删除液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param fSafetyDeviceIds 需要删除的液化石油气监管-液化气用户-安全装置加装维护ID
     * @return 结果
     */
    @Override
    public int deleteTYehuaqiuserSafetyDeviceInfoByIds(Long[] fSafetyDeviceIds)
    {
        return tYehuaqiuserSafetyDeviceInfoMapper.deleteTYehuaqiuserSafetyDeviceInfoByIds(fSafetyDeviceIds);
    }

    /**
     * 删除液化石油气监管-液化气用户-安全装置加装维护信息
     * 
     * @param fSafetyDeviceId 液化石油气监管-液化气用户-安全装置加装维护ID
     * @return 结果
     */
    @Override
    public int deleteTYehuaqiuserSafetyDeviceInfoById(Long fSafetyDeviceId)
    {
        return tYehuaqiuserSafetyDeviceInfoMapper.deleteTYehuaqiuserSafetyDeviceInfoById(fSafetyDeviceId);
    }
}
