package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.domain.TUserLocation;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.domain.vo.HomepageVo;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import com.zehong.system.mapper.TWorkOrderMapper;
import com.zehong.system.service.ITWorkOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.xml.stream.Location;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 燃气任务Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-10
 */
@Service
public class TWorkOrderServiceImpl implements ITWorkOrderService 
{
    @Autowired
    private TWorkOrderMapper tWorkOrderMapper;

    @Autowired
    private TEnterpriseInfoMapper tEnterpriseInfoMapper;

    /**
     * 查询燃气任务
     * 
     * @param workId 燃气任务ID
     * @return 燃气任务
     */
    @Override
    public TWorkOrder selectTWorkOrderById(Long workId)
    {
        TWorkOrder wo =tWorkOrderMapper.selectTWorkOrderById(workId);
        List<String[]> list = new ArrayList<>();
        List<TUserLocation> tulist = tWorkOrderMapper.selectTuserList(wo);
        for(TUserLocation user :tulist){
            String[] a = {user.getLongitude(),user.getLatitude()};
            list.add(a);
        }
        wo.setLocationList(list);
        return wo;
    }

    /**
     * 查询燃气任务列表
     * 
     * @param tWorkOrder 燃气任务
     * @return 燃气任务
     */
    @Override
    public List<TWorkOrder> selectTWorkOrderList(TWorkOrder tWorkOrder)
    {
        return tWorkOrderMapper.selectTWorkOrderList(tWorkOrder);
    }
    @Override
    public List<Map<String,Object>> selectTWorkOrderListCount(TWorkOrder tWorkOrder)
    {
        return tWorkOrderMapper.selectTWorkOrderListCount(tWorkOrder);
    }

    /**
     * 燃气任务统计
     *
     * @return 燃气任务统计
     */
    public HomepageVo countTWorkOrder()
    {
        return tWorkOrderMapper.countTWorkOrder();
    }

    /**
     * 新增燃气任务
     * 
     * @param tWorkOrder 燃气任务
     * @return 结果
     */
    @Override
    public int insertTWorkOrder(TWorkOrder tWorkOrder)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tWorkOrder.setCreateTime(DateUtils.getNowDate());
        tWorkOrder.setCreateBy(SecurityUtils.getUsername());
        String enterpriseId = user.getDeptId();
        if(null != enterpriseId){
            if("-2".equals(enterpriseId.toString())){
                tWorkOrder.setWorkCreateEnterpriseId("-2");
                tWorkOrder.setWorkCreateEnterpriseName("政府部门");
            }else{

                TEnterpriseInfo enterpriseInfo = tEnterpriseInfoMapper.selectTEnterpriseInfoById(enterpriseId);
                if(null != enterpriseInfo && StringUtils.isNotEmpty(enterpriseInfo.getEnterpriseName())){
                    tWorkOrder.setWorkCreateEnterpriseId(enterpriseId.toString());
                    tWorkOrder.setWorkCreateEnterpriseName(enterpriseInfo.getEnterpriseName());
                }
                if(tWorkOrder.getWorkAssignEnterproseId()==null){
                    tWorkOrder.setWorkAssignEnterproseId(enterpriseId);
                    tWorkOrder.setWorkAssignEnterproseName(enterpriseInfo.getEnterpriseName());
                    tWorkOrder.setWorkAssignManId(user.getUserId());
                    tWorkOrder.setWorkAssignMan(user.getUserName());
                }

            }
        }
        if(tWorkOrder.getCreateType() != null && tWorkOrder.getCreateType()==2){
            tWorkOrder.setShangbaoTime(new Date(System.currentTimeMillis()+1000*60*5));
            tWorkOrder.setJiedanTime(new Date(System.currentTimeMillis()-1000*60*5));
        }
        return tWorkOrderMapper.insertTWorkOrder(tWorkOrder);
    }

    /**
     * 添加定位信息
     * @return
     */
    public int insertsLocations(String locations){
        List<TUserLocation> list =(List<TUserLocation> ) JSONObject.parse(locations);
        return tWorkOrderMapper.insertTUserLocationList(list);
    }
    public int insertsLocation(TUserLocation location){
        location.setCreateTime(new Date());
        List<TUserLocation> list = new ArrayList<>();
        list.add(location);
        return tWorkOrderMapper.insertTUserLocationList(list);
    }
    /**
     * 修改燃气任务
     * 
     * @param tWorkOrder 燃气任务
     * @return 结果
     */
    @Override
    public int updateTWorkOrder(TWorkOrder tWorkOrder)
    {
        tWorkOrder.setUpdateTime(DateUtils.getNowDate());
        tWorkOrder.setUpdateBy(SecurityUtils.getUsername());
        /*if(StringUtils.isNotEmpty(tWorkOrder.getIconUrl()) || StringUtils.isNotEmpty(tWorkOrder.getRectificationResult())){
            tWorkOrder.setWorkStatus("2");
        }*/
        if(tWorkOrder.getWorkStatus()!=null && tWorkOrder.getWorkStatus().equals("1")){
            tWorkOrder.setJiedanTime(new Date());
        }
        if(tWorkOrder.getWorkStatus()!=null && tWorkOrder.getWorkStatus().equals("2")){
            tWorkOrder.setShangbaoTime(new Date());
        }
        return tWorkOrderMapper.updateTWorkOrder(tWorkOrder);
    }

    /**
     * 批量删除燃气任务
     * 
     * @param workIds 需要删除的燃气任务ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderByIds(Long[] workIds)
    {
        return tWorkOrderMapper.deleteTWorkOrderByIds(workIds);
    }

    /**
     * 删除燃气任务信息
     * 
     * @param workId 燃气任务ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderById(Long workId)
    {
        return tWorkOrderMapper.deleteTWorkOrderById(workId);
    }

    /**
     *
     * @param enterpriseId
     * @return
     */

    @Override
    public Map<String,Object> selectWorkOrderNum(String enterpriseId){
        return tWorkOrderMapper.selectWorkOrderNum(enterpriseId.split(","));
    }
}
