package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TVillageLevelRegionMapper;
import com.zehong.system.domain.TVillageLevelRegion;
import com.zehong.system.service.ITVillageLevelRegionService;

/**
 * 村级行政区Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-07
 */
@Service
public class TVillageLevelRegionServiceImpl implements ITVillageLevelRegionService 
{
    @Autowired
    private TVillageLevelRegionMapper tVillageLevelRegionMapper;

    /**
     * 查询村级行政区
     * 
     * @param fId 村级行政区ID
     * @return 村级行政区
     */
    @Override
    public TVillageLevelRegion selectTVillageLevelRegionById(Long fId)
    {
        return tVillageLevelRegionMapper.selectTVillageLevelRegionById(fId);
    }

    /**
     * 查询村级行政区列表
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 村级行政区
     */
    @Override
    public List<TVillageLevelRegion> selectTVillageLevelRegionList(TVillageLevelRegion tVillageLevelRegion)
    {
        return tVillageLevelRegionMapper.selectTVillageLevelRegionList(tVillageLevelRegion);
    }

    /**
     * 新增村级行政区
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 结果
     */
    @Override
    public int insertTVillageLevelRegion(TVillageLevelRegion tVillageLevelRegion)
    {
        return tVillageLevelRegionMapper.insertTVillageLevelRegion(tVillageLevelRegion);
    }

    /**
     * 修改村级行政区
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 结果
     */
    @Override
    public int updateTVillageLevelRegion(TVillageLevelRegion tVillageLevelRegion)
    {
        return tVillageLevelRegionMapper.updateTVillageLevelRegion(tVillageLevelRegion);
    }

    /**
     * 批量删除村级行政区
     * 
     * @param fIds 需要删除的村级行政区ID
     * @return 结果
     */
    @Override
    public int deleteTVillageLevelRegionByIds(Long[] fIds)
    {
        return tVillageLevelRegionMapper.deleteTVillageLevelRegionByIds(fIds);
    }

    /**
     * 删除村级行政区信息
     * 
     * @param fId 村级行政区ID
     * @return 结果
     */
    @Override
    public int deleteTVillageLevelRegionById(Long fId)
    {
        return tVillageLevelRegionMapper.deleteTVillageLevelRegionById(fId);
    }
}
