package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TVehicleUseRecord;
import com.zehong.system.mapper.TVehicleUseRecordMapper;
import com.zehong.system.service.ITVehicleUseRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 车辆使用记录Service业务层处理
 * 
 * @author zehong
 * @date 2023-08-19
 */
@Service
public class TVehicleUseRecordServiceImpl implements ITVehicleUseRecordService
{
    @Autowired
    private TVehicleUseRecordMapper tVehicleUseRecordMapper;

    /**
     * 查询车辆使用记录
     * 
     * @param vehicleUseRecordId 车辆使用记录ID
     * @return 车辆使用记录
     */
    @Override
    public TVehicleUseRecord selectTVehicleUseRecordById(Long vehicleUseRecordId)
    {
        return tVehicleUseRecordMapper.selectTVehicleUseRecordById(vehicleUseRecordId);
    }

    /**
     * 查询车辆使用记录列表
     * 
     * @param tVehicleUseRecord 车辆使用记录
     * @return 车辆使用记录
     */
    @Override
    public List<TVehicleUseRecord> selectTVehicleUseRecordList(TVehicleUseRecord tVehicleUseRecord)
    {
        return tVehicleUseRecordMapper.selectTVehicleUseRecordList(tVehicleUseRecord);
    }

    /**
     * 新增车辆使用记录
     * 
     * @param tVehicleUseRecord 车辆使用记录
     * @return 结果
     */
    @Override
    public int insertTVehicleUseRecord(TVehicleUseRecord tVehicleUseRecord)
    {
        tVehicleUseRecord.setCreateTime(DateUtils.getNowDate());
        return tVehicleUseRecordMapper.insertTVehicleUseRecord(tVehicleUseRecord);
    }

    /**
     * 修改车辆使用记录
     * 
     * @param tVehicleUseRecord 车辆使用记录
     * @return 结果
     */
    @Override
    public int updateTVehicleUseRecord(TVehicleUseRecord tVehicleUseRecord)
    {
        tVehicleUseRecord.setUpdateTime(DateUtils.getNowDate());
        return tVehicleUseRecordMapper.updateTVehicleUseRecord(tVehicleUseRecord);
    }

    /**
     * 批量删除车辆使用记录
     * 
     * @param vehicleUseRecordIds 需要删除的车辆使用记录ID
     * @return 结果
     */
    @Override
    public int deleteTVehicleUseRecordByIds(Long[] vehicleUseRecordIds)
    {
        return tVehicleUseRecordMapper.deleteTVehicleUseRecordByIds(vehicleUseRecordIds);
    }

    /**
     * 删除车辆使用记录信息
     * 
     * @param vehicleUseRecordId 车辆使用记录ID
     * @return 结果
     */
    @Override
    public int deleteTVehicleUseRecordById(Long vehicleUseRecordId)
    {
        return tVehicleUseRecordMapper.deleteTVehicleUseRecordById(vehicleUseRecordId);
    }
}
