package com.zehong.system.service.impl;

import java.util.List;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TUserManageVillageMapper;
import com.zehong.system.domain.TUserManageVillage;
import com.zehong.system.service.ITUserManageVillageService;

import javax.annotation.Resource;

/**
 * 基本信息维护-用户管理-居住区(村庄)Service业务层处理
 * 
 * @author zehong
 * @date 2024-08-27
 */
@Service
public class TUserManageVillageServiceImpl implements ITUserManageVillageService 
{
    @Resource
    private TUserManageVillageMapper tUserManageVillageMapper;

    /**
     * 查询基本信息维护-用户管理-居住区(村庄)
     * 
     * @param fVillageId 基本信息维护-用户管理-居住区(村庄)ID
     * @return 基本信息维护-用户管理-居住区(村庄)
     */
    @Override
    public TUserManageVillage selectTUserManageVillageById(Long fVillageId)
    {
        return tUserManageVillageMapper.selectTUserManageVillageById(fVillageId);
    }

    /**
     * 查询基本信息维护-用户管理-居住区(村庄)列表
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 基本信息维护-用户管理-居住区(村庄)
     */
    @Override
    public List<TUserManageVillage> selectTUserManageVillageList(TUserManageVillage tUserManageVillage)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        String deptId = user.getDeptId();
        tUserManageVillage.setBeyondEnterpriseId(deptId);
        return tUserManageVillageMapper.selectTUserManageVillageList(tUserManageVillage);
    }

    /**
     * 提供给第三方使用的 分页查询
     * @param pageNum p
     * @param pageSize p
     * @return
     */
    @Override
    public List<TUserManageVillage> queryUserManageVillageForThirdParty(Integer pageNum, Integer pageSize) {

        PageHelper.startPage(pageNum,pageSize);
        List<TUserManageVillage> userManageVillages = tUserManageVillageMapper.queryUserManageVillageForThirdParty();
        PageInfo<TUserManageVillage> pageInfo = new PageInfo<>(userManageVillages);
        return pageInfo.getList();
    }

    /**
     * 查询基本信息维护-用户管理-居住区(村庄)导出
     *
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 基本信息维护-用户管理-居住区(村庄)
     */
    @Override
    public List<TUserManageVillage> exportTUserManageVillageList(TUserManageVillage tUserManageVillage) {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        String deptId = user.getDeptId();
        tUserManageVillage.setBeyondEnterpriseId(deptId);
        return tUserManageVillageMapper.exportUserManageVillageList(tUserManageVillage);
    }

    /**
     * 根据 村名称集合 查询 村集合
     * @param villageNames v
     * @return r
     */
    @Override
    public List<TUserManageVillage> queryByVillageNames(List<String> villageNames) {
        return tUserManageVillageMapper.queryByVillageNames(villageNames);
    }

    /**
     * 根据 id 集合查询
     * @param villageIds v
     * @return r
     */
    @Override
    public List<TUserManageVillage> queryByVillageIds(List<Long> villageIds) {
        return tUserManageVillageMapper.queryByVillageIds(villageIds);
    }

    /**
     * 新增基本信息维护-用户管理-居住区(村庄)
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 结果
     */
    @Override
    public int insertTUserManageVillage(TUserManageVillage tUserManageVillage)
    {
        return tUserManageVillageMapper.insertTUserManageVillage(tUserManageVillage);
    }

    /**
     * 批量插入
     * @param userManageVillages s
     * @return r
     */
    @Override
    public int insertBatch(List<TUserManageVillage> userManageVillages) {
        return tUserManageVillageMapper.insertBatch(userManageVillages);
    }

    /**
     * 修改基本信息维护-用户管理-居住区(村庄)
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 结果
     */
    @Override
    public int updateTUserManageVillage(TUserManageVillage tUserManageVillage)
    {
        return tUserManageVillageMapper.updateTUserManageVillage(tUserManageVillage);
    }

    /**
     * 批量删除基本信息维护-用户管理-居住区(村庄)
     * 
     * @param fVillageIds 需要删除的基本信息维护-用户管理-居住区(村庄)ID
     * @return 结果
     */
    @Override
    public int deleteTUserManageVillageByIds(Long[] fVillageIds)
    {
        return tUserManageVillageMapper.deleteTUserManageVillageByIds(fVillageIds);
    }

    /**
     * 删除基本信息维护-用户管理-居住区(村庄)信息
     * 
     * @param fVillageId 基本信息维护-用户管理-居住区(村庄)ID
     * @return 结果
     */
    @Override
    public int deleteTUserManageVillageById(Long fVillageId)
    {
        return tUserManageVillageMapper.deleteTUserManageVillageById(fVillageId);
    }
}
