package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TLinePatrolPerson;
import com.zehong.system.mapper.TLinePatrolPersonMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTransferPostRecordMapper;
import com.zehong.system.domain.TTransferPostRecord;
import com.zehong.system.service.ITTransferPostRecordService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 调岗记录Service业务层处理
 * 
 * @author zehong
 * @date 2023-09-21
 */
@Service
public class TTransferPostRecordServiceImpl implements ITTransferPostRecordService 
{
    @Autowired
    private TTransferPostRecordMapper tTransferPostRecordMapper;
    @Autowired
    private TLinePatrolPersonMapper tLinePatrolPersonMapper;

    /**
     * 查询调岗记录
     * 
     * @param recordId 调岗记录ID
     * @return 调岗记录
     */
    @Override
    public TTransferPostRecord selectTTransferPostRecordById(Long recordId)
    {
        return tTransferPostRecordMapper.selectTTransferPostRecordById(recordId);
    }

    /**
     * 查询调岗记录列表
     * 
     * @param tTransferPostRecord 调岗记录
     * @return 调岗记录
     */
    @Override
    public List<TTransferPostRecord> selectTTransferPostRecordList(TTransferPostRecord tTransferPostRecord)
    {
        return tTransferPostRecordMapper.selectTTransferPostRecordList(tTransferPostRecord);
    }
    @Override
    public List<TTransferPostRecord> xiaolist(TTransferPostRecord tTransferPostRecord)
    {
        return tTransferPostRecordMapper.xiaolist(tTransferPostRecord);
    }

    /**
     * 新增调岗记录
     * 
     * @param tTransferPostRecord 调岗记录
     * @return 结果
     */
    @Override
    public int insertTTransferPostRecord(TTransferPostRecord tTransferPostRecord)
    {
        tTransferPostRecord.setCreateTime(DateUtils.getNowDate());
        return tTransferPostRecordMapper.insertTTransferPostRecord(tTransferPostRecord);
    }

    /**
     * 修改调岗记录
     * 
     * @param tTransferPostRecord 调岗记录
     * @return 结果
     */
    @Override
    @Transactional( rollbackFor = Exception.class)
    public int updateTTransferPostRecord(TTransferPostRecord tTransferPostRecord)
    {
        tTransferPostRecord.setUpdateTime(DateUtils.getNowDate());
        Integer a =tTransferPostRecordMapper.updateTTransferPostRecord(tTransferPostRecord);
        if(tTransferPostRecord.getTransferStatus().equals("1")){
            TTransferPostRecord r =tTransferPostRecordMapper.selectTTransferPostRecordById(tTransferPostRecord.getRecordId());
            TLinePatrolPerson p = new TLinePatrolPerson();
            p.setPersonId(r.getApplyId());
            p.setGroupNum(r.getTransferGroupNum());
            tLinePatrolPersonMapper.updateTLinePatrolPerson(p);
        }
        return a;
    }

    /**
     * 批量删除调岗记录
     * 
     * @param recordIds 需要删除的调岗记录ID
     * @return 结果
     */
    @Override
    public int deleteTTransferPostRecordByIds(Long[] recordIds)
    {
        return tTransferPostRecordMapper.deleteTTransferPostRecordByIds(recordIds);
    }

    /**
     * 删除调岗记录信息
     * 
     * @param recordId 调岗记录ID
     * @return 结果
     */
    @Override
    public int deleteTTransferPostRecordById(Long recordId)
    {
        return tTransferPostRecordMapper.deleteTTransferPostRecordById(recordId);
    }
}
