package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSiteStationInfoMapper;
import com.zehong.system.domain.TSiteStationInfo;
import com.zehong.system.service.ITSiteStationInfoService;

/**
 * 场站信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-01-27
 */
@Service
public class TSiteStationInfoServiceImpl implements ITSiteStationInfoService 
{
    @Autowired
    private TSiteStationInfoMapper tSiteStationInfoMapper;

    /**
     * 查询场站信息
     * 
     * @param siteStationId 场站信息ID
     * @return 场站信息
     */
    @Override
    public TSiteStationInfo selectTSiteStationInfoById(Long siteStationId)
    {
        return tSiteStationInfoMapper.selectTSiteStationInfoById(siteStationId);
    }

    /**
     * 查询场站信息列表
     * 
     * @param tSiteStationInfo 场站信息
     * @return 场站信息
     */
    @Override
    public List<TSiteStationInfo> selectTSiteStationInfoList(TSiteStationInfo tSiteStationInfo)
    {
        return tSiteStationInfoMapper.selectTSiteStationInfoList(tSiteStationInfo);
    }

    /**
     * 新增场站信息
     * 
     * @param tSiteStationInfo 场站信息
     * @return 结果
     */
    @Override
    public int insertTSiteStationInfo(TSiteStationInfo tSiteStationInfo)
    {
        tSiteStationInfo.setCreateTime(DateUtils.getNowDate());
        return tSiteStationInfoMapper.insertTSiteStationInfo(tSiteStationInfo);
    }

    /**
     * 修改场站信息
     * 
     * @param tSiteStationInfo 场站信息
     * @return 结果
     */
    @Override
    public int updateTSiteStationInfo(TSiteStationInfo tSiteStationInfo)
    {
        tSiteStationInfo.setUpdateTime(DateUtils.getNowDate());
        return tSiteStationInfoMapper.updateTSiteStationInfo(tSiteStationInfo);
    }

    /**
     * 批量删除场站信息
     * 
     * @param siteStationIds 需要删除的场站信息ID
     * @return 结果
     */
    @Override
    public int deleteTSiteStationInfoByIds(Long[] siteStationIds)
    {
        return tSiteStationInfoMapper.deleteTSiteStationInfoByIds(siteStationIds);
    }

    /**
     * 删除场站信息信息
     * 
     * @param siteStationId 场站信息ID
     * @return 结果
     */
    @Override
    public int deleteTSiteStationInfoById(Long siteStationId)
    {
        return tSiteStationInfoMapper.deleteTSiteStationInfoById(siteStationId);
    }
}
