package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.domain.TLpgGasBottleFiles;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import com.zehong.system.mapper.TLpgGasBottleFilesMapper;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TLpgAirChargeFilesMapper;
import com.zehong.system.domain.TLpgAirChargeFiles;
import com.zehong.system.service.ITLpgAirChargeFilesService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油气-充装记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-07-09
 */
@Service
public class TLpgAirChargeFilesServiceImpl implements ITLpgAirChargeFilesService 
{
    @Resource
    private TLpgAirChargeFilesMapper tLpgAirChargeFilesMapper;

    @Resource
    private TLpgGasBottleFilesMapper tLpgGasBottleFilesMapper;

    @Resource
    private TEnterpriseInfoMapper enterpriseInfoMapper;

    /**
     * 查询液化石油气-充装记录
     * 
     * @param fGasAirChargeId 液化石油气-充装记录ID
     * @return 液化石油气-充装记录
     */
    @Override
    public TLpgAirChargeFiles selectTLpgAirChargeFilesById(Long fGasAirChargeId)
    {
        return tLpgAirChargeFilesMapper.selectTLpgAirChargeFilesById(fGasAirChargeId);
    }

    @Override
    public Integer selectTLpgAirChargeFilesTotal()
    {
        return tLpgAirChargeFilesMapper.selectTLpgAirChargeFilesTotal();
    }


    /**
     * 查询液化石油气-充装记录列表
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 液化石油气-充装记录
     */
    @Override
    public List<TLpgAirChargeFiles> selectTLpgAirChargeFilesList(TLpgAirChargeFiles tLpgAirChargeFiles)
    {
        return tLpgAirChargeFilesMapper.selectTLpgAirChargeFilesList(tLpgAirChargeFiles);
    }

    @Override
    public List<TLpgAirChargeFiles> queryALlByBarcodeAndGizId(List<TLpgAirChargeFiles> tLpgAirChargeFiles) {
        return tLpgAirChargeFilesMapper.queryALlByBarcodeAndGizId(tLpgAirChargeFiles);
    }

    /**
     * 2024-09-12 wh 查询数据为了导出用 限制导出数量
     * @param tLpgAirChargeFiles t
     * @return r
     */
    @Override
    public List<TLpgAirChargeFiles> queryAllForExport(TLpgAirChargeFiles tLpgAirChargeFiles) {
        return tLpgAirChargeFilesMapper.queryAllForExport(tLpgAirChargeFiles);
    }

    /**
     * 新增液化石油气-充装记录
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 结果
     */
    @Override
    public int insertTLpgAirChargeFiles(TLpgAirChargeFiles tLpgAirChargeFiles)
    {
        return tLpgAirChargeFilesMapper.insertTLpgAirChargeFiles(tLpgAirChargeFiles);
    }

    /**
     * 修改液化石油气-充装记录
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 结果
     */
    @Override
    public int updateTLpgAirChargeFiles(TLpgAirChargeFiles tLpgAirChargeFiles)
    {
        return tLpgAirChargeFilesMapper.updateTLpgAirChargeFiles(tLpgAirChargeFiles);
    }

    /**
     * 批量删除液化石油气-充装记录
     * 
     * @param fGasAirChargeIds 需要删除的液化石油气-充装记录ID
     * @return 结果
     */
    @Override
    public int deleteTLpgAirChargeFilesByIds(Long[] fGasAirChargeIds)
    {
        return tLpgAirChargeFilesMapper.deleteTLpgAirChargeFilesByIds(fGasAirChargeIds);
    }

    /**
     * 删除液化石油气-充装记录信息
     * 
     * @param fGasAirChargeId 液化石油气-充装记录ID
     * @return 结果
     */
    @Override
    public int deleteTLpgAirChargeFilesById(Long fGasAirChargeId)
    {
        return tLpgAirChargeFilesMapper.deleteTLpgAirChargeFilesById(fGasAirChargeId);
    }

    /**
     * 导出
     * @param xmbhList data
     * @param updateSupport 是否更新
     * @param response res
     */
    @Override
    public Map<String,Object> importLpgAirChargeFileInfo(List<TLpgAirChargeFiles> xmbhList, boolean updateSupport, HttpServletResponse response) {

        Map<String ,Object> map = new HashMap<>();

        int errorNum = 0;
        int successNum = 0;

        List<TLpgAirChargeFiles> successList = new ArrayList<>();
        if (xmbhList != null && xmbhList.size() > 0) {

            if (xmbhList.size() > 500) {
                map.put("errorMsg","导入数据不允许超过500条");
                return map;
            }

            // 2024-09-14 调整 ，燃气企业也得有
            List<TLpgAirChargeFiles> havaBarCodeList = xmbhList.stream()
                    .filter(item -> StringUtils.isNotBlank(item.getBarCode()) &&
                            StringUtils.isNotBlank(item.getEnterpriseName()))
                    .collect(Collectors.toList());

            // 气瓶条码集合
            List<String> collect = havaBarCodeList.stream().map(TLpgAirChargeFiles::getBarCode).collect(Collectors.toList());
            // 燃气企业结合
            List<String> collectEnterprise = havaBarCodeList.stream().map(TLpgAirChargeFiles::getEnterpriseName).collect(Collectors.toList());

            // 这是 上面气瓶条码 有的气瓶数据
            List<TLpgGasBottleFiles> tLpgGasBottleFiles2 = tLpgGasBottleFilesMapper.queryAllByFQRcodeList(collect);
            // 按照 气瓶条码 分组
            Map<String, List<TLpgGasBottleFiles>> collect1 = tLpgGasBottleFiles2.stream().collect(Collectors.groupingBy(TLpgGasBottleFiles::getQrcode));

            // 燃气企业结合
            List<TEnterpriseInfo> tEnterpriseInfos = enterpriseInfoMapper.queryAllByEnterpriseNameList(collectEnterprise);
            // 按照企业名称分组
            Map<String, List<TEnterpriseInfo>> collect2 = tEnterpriseInfos.stream().collect(Collectors.groupingBy(TEnterpriseInfo::getEnterpriseName));


            errorNum += (xmbhList.size() - havaBarCodeList.size());

            for (TLpgAirChargeFiles tLpgAirChargeFiles : havaBarCodeList) {

                List<TLpgGasBottleFiles> tLpgGasBottleFiles = collect1.get(tLpgAirChargeFiles.getBarCode());
                if (tLpgGasBottleFiles == null || tLpgGasBottleFiles.size() == 0) {
                    errorNum++;
                    continue;
                }
                List<TEnterpriseInfo> tEnterpriseInfos1 = collect2.get(tLpgAirChargeFiles.getEnterpriseName());
                if (tEnterpriseInfos1 == null || tEnterpriseInfos1.size() == 0) {
                    errorNum++;
                    continue;
                }
                successList.add(tLpgAirChargeFiles);
                successNum++;
            }

            if (successList.size() > 0) {

                tLpgAirChargeFilesMapper.insertBatch(successList);
            }

            map.put("errorNum",errorNum);
            map.put("successNum",successNum);

        } else {
            map.put("errorNum",errorNum);
            map.put("successNum",successNum);
        }

        return map;
    }

    /**
     * 第三方对接 接收到的数据
     * @param list list
     * @return r
     */
    @Override
    public int externalDockingCreateLpgAirChargeFileInfo(List<TLpgAirChargeFiles> list) {
        return tLpgAirChargeFilesMapper.insertBatch(list);
    }

    /**
     * 修改
     * @param list list
     * @return r
     */
    @Override
    public int externalDockingUpdateLpgAirChargeFileInfo(List<TLpgAirChargeFiles> list) {
        return tLpgAirChargeFilesMapper.updateBatch(list);
    }
}
