package com.zehong.system.service.impl;

import com.zehong.system.domain.THiddenDangerStandingBook;
import com.zehong.system.domain.THiddenTroubleInfo;
import com.zehong.system.mapper.THiddenDangerStandingBookMapper;
import com.zehong.system.mapper.THiddenTroubleInfoMapper;
import com.zehong.system.service.ITHiddenTroubleInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 燃气隐患Service业务层处理
 *
 * @author zehong
 * @date 2022-03-24
 */
@Service
public class THiddenTroubleInfoServiceImpl implements ITHiddenTroubleInfoService
{
    @Autowired
    private THiddenTroubleInfoMapper tHiddenTroubleInfoMapper;

    @Resource
    private THiddenDangerStandingBookMapper tHiddenDangerStandingBookMapper;

    /**
     * 查询燃气隐患
     *
     * @param hiddenTroubleId 燃气隐患ID
     * @return 燃气隐患
     */
    @Override
    public THiddenTroubleInfo selectTHiddenTroubleInfoById(Long hiddenTroubleId)
    {
        return tHiddenTroubleInfoMapper.selectTHiddenTroubleInfoById(hiddenTroubleId);
    }

    /**
     * 查询燃气隐患列表
     *
     * @param tHiddenTroubleInfo 燃气隐患
     * @return 燃气隐患
     */
    @Override
    public List<THiddenTroubleInfo> selectTHiddenTroubleInfoList(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        return tHiddenTroubleInfoMapper.selectTHiddenTroubleInfoList(tHiddenTroubleInfo);
    }
    @Override
    public List<Map<String,Object>> selectTHiddenTroubleInfoListCount(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        return tHiddenTroubleInfoMapper.selectTHiddenTroubleInfoListCount(tHiddenTroubleInfo);
    }


    /**
     * 新增燃气隐患
     *
     * @param tHiddenTroubleInfo 燃气隐患
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor= Exception.class)
    public int insertTHiddenTroubleInfo(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        return tHiddenTroubleInfoMapper.insertTHiddenTroubleInfo(tHiddenTroubleInfo);
    }

    /**
     * 修改燃气隐患
     *
     * @param tHiddenTroubleInfo 燃气隐患
     * @return 结果
     */
    @Override
    public int updateTHiddenTroubleInfo(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        if(tHiddenTroubleInfo.getHiddenTroubleDealStatus().equals("2")){
            tHiddenTroubleInfo.setHiddenTroubleDealFinishTime(new Date());
        }
        if(tHiddenTroubleInfo.getHiddenTroubleDealStatus().equals("3")||tHiddenTroubleInfo.getFuhePerson()!=null){
            tHiddenTroubleInfo.setFuheTime(new Date());
        }
        return tHiddenTroubleInfoMapper.updateTHiddenTroubleInfo(tHiddenTroubleInfo);
    }

    /**
     * 批量删除燃气隐患
     *
     * @param hiddenTroubleIds 需要删除的燃气隐患ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenTroubleInfoByIds(Long[] hiddenTroubleIds)
    {
        return tHiddenTroubleInfoMapper.deleteTHiddenTroubleInfoByIds(hiddenTroubleIds);
    }

    /**
     * 删除燃气隐患信息
     *
     * @param hiddenTroubleId 燃气隐患ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenTroubleInfoById(Long hiddenTroubleId)
    {
        return tHiddenTroubleInfoMapper.deleteTHiddenTroubleInfoById(hiddenTroubleId);
    }

    /**
     * Excel数据导出查询接口
     * @param tHiddenTroubleInfo
     * @return
     */
    @Override
    public List<THiddenTroubleInfo> selectTHiddenTroubleInfoExcelList(THiddenTroubleInfo tHiddenTroubleInfo) {
        return tHiddenTroubleInfoMapper.selectTHiddenTroubleInfoExcelList(tHiddenTroubleInfo);
    }

    /**
     * 查询燃气信息是否有修改
     * @param tHiddenTroubleInfo
     * @return
     */
    @Override
    public THiddenTroubleInfo selectDetails(THiddenTroubleInfo tHiddenTroubleInfo) {
        return tHiddenTroubleInfoMapper.selectDetails(tHiddenTroubleInfo);
    }

    /**
     * 上报
     * @param tHiddenTroubleInfo
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public int reportGovernment(THiddenTroubleInfo tHiddenTroubleInfo) throws ParseException {
        THiddenTroubleInfo hiddenTroubleInfo = tHiddenTroubleInfoMapper.selectTHiddenTroubleInfoById(tHiddenTroubleInfo.getHiddenTroubleId());
        /*隐患整治台账添加*/
        THiddenDangerStandingBook tHiddenDangerStandingBook=new THiddenDangerStandingBook();
        //隐患名称
        tHiddenDangerStandingBook.setHiddenTitle(hiddenTroubleInfo.getHiddenTroubleName());
        //隐患内容
        tHiddenDangerStandingBook.setHiddenContent(hiddenTroubleInfo.getHiddenTroubleDescribe());
        //隐患等级
        tHiddenDangerStandingBook.setHiddenType(hiddenTroubleInfo.getHiddenTroubleLevel());
        /*隐患位置*//*
        tHiddenDangerStandingBook.setHiddenLocation();*/
        /*隐患发现人员*/
        tHiddenDangerStandingBook.setHiddenFindPeople(hiddenTroubleInfo.getReportPerson());
        /*经度   纬度*/
        tHiddenDangerStandingBook.setLongitude(hiddenTroubleInfo.getLongitude());
        tHiddenDangerStandingBook.setLatitude(hiddenTroubleInfo.getLatitude());
        tHiddenDangerStandingBook.setRemediation(hiddenTroubleInfo.getHiddenTroubleDealStatus());
        tHiddenDangerStandingBook.setRemarks(hiddenTroubleInfo.getRemarks());
        tHiddenDangerStandingBook.setHiddenFindDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(hiddenTroubleInfo.getReportTime()));
        tHiddenDangerStandingBook.setBeyondEnterpriseId(hiddenTroubleInfo.getBeyondEnterpriseId());
        tHiddenDangerStandingBook.setCreateTime(new Date());
        tHiddenDangerStandingBook.setHiddenTroubleType(hiddenTroubleInfo.getHiddenTroubleType());
        tHiddenDangerStandingBookMapper.insertTHiddenDangerStandingBook(tHiddenDangerStandingBook);
        return tHiddenTroubleInfoMapper.updateTHiddenTroubleInfo(tHiddenTroubleInfo);
    }
}
