package com.zehong.system.service.impl;

import java.util.*;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.exception.BaseException;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.bean.BeanUtils;
import com.zehong.system.domain.TEmployedPeopleInfoError;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.mapper.TEmployedPeopleInfoErrorMapper;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmployedPeopleInfoMapper;
import com.zehong.system.domain.TEmployedPeopleInfo;
import com.zehong.system.service.ITEmployedPeopleInfoService;

import javax.servlet.http.HttpServletResponse;

/**
 * 从业人员信息Service业务层处理
 *
 * @author zehong
 * @date 2022-01-25
 */
@Service
public class TEmployedPeopleInfoServiceImpl implements ITEmployedPeopleInfoService
{
    @Autowired
    private TEmployedPeopleInfoMapper tEmployedPeopleInfoMapper;

    @Autowired
    private TEnterpriseInfoMapper enterpriseInfoMapper;

    @Autowired
    private TEmployedPeopleInfoErrorMapper employedPeopleInfoErrorMapper;

    /**
     * 查询从业人员信息
     *
     * @param employedPeopleId 从业人员信息ID
     * @return 从业人员信息
     */
    @Override
    public TEmployedPeopleInfo selectTEmployedPeopleInfoById(Long employedPeopleId)
    {
        return tEmployedPeopleInfoMapper.selectTEmployedPeopleInfoById(employedPeopleId);
    }

    /**
     * 查询从业人员信息列表
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 从业人员信息
     */
    @Override
    public List<TEmployedPeopleInfo> selectTEmployedPeopleInfoList(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        return tEmployedPeopleInfoMapper.selectTEmployedPeopleInfoList(tEmployedPeopleInfo);
    }

    /**
     * 新增从业人员信息
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 结果
     */
    @Override
    public int insertTEmployedPeopleInfo(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        tEmployedPeopleInfo.setCreateTime(DateUtils.getNowDate());
        return tEmployedPeopleInfoMapper.insertTEmployedPeopleInfo(tEmployedPeopleInfo);
    }

    /**
     * 修改从业人员信息
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 结果
     */
    @Override
    public int updateTEmployedPeopleInfo(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        tEmployedPeopleInfo.setUpdateTime(DateUtils.getNowDate());
        return tEmployedPeopleInfoMapper.updateTEmployedPeopleInfo(tEmployedPeopleInfo);
    }

    /**
     * 批量删除从业人员信息
     *
     * @param employedPeopleIds 需要删除的从业人员信息ID
     * @return 结果
     */
    @Override
    public int deleteTEmployedPeopleInfoByIds(Long[] employedPeopleIds)
    {
        return tEmployedPeopleInfoMapper.deleteTEmployedPeopleInfoByIds(employedPeopleIds);
    }

    /**
     * 删除从业人员信息信息
     *
     * @param employedPeopleId 从业人员信息ID
     * @return 结果
     */
    @Override
    public int deleteTEmployedPeopleInfoById(Long employedPeopleId)
    {
        return tEmployedPeopleInfoMapper.deleteTEmployedPeopleInfoById(employedPeopleId);
    }

    /**
     * 企业信息查询(下拉框数据)
     * @return
     */
    @Override
    public List<TEnterpriseInfo> selectTEnterprise(String deptId) {
        return tEmployedPeopleInfoMapper.selectTEnterprise(deptId);
    }

    /**
     * 根据企业id查询企业名称
     * @param bId
     * @return
     */
    @Override
    public String selectEnterpriseName(String bId) {
        String s = tEmployedPeopleInfoMapper.selectEnterpriseName(bId);
        return s;
    }

    @Override
    public String importEmployedPeopleInfo(List<TEmployedPeopleInfoError> employedPeopleInfos, Boolean isUpdateSupport, String operName, HttpServletResponse response) {

        if (CollectionUtils.isEmpty(employedPeopleInfos)) {
            throw new BaseException("导入数据不能为空！ ");
        }
        List<TEmployedPeopleInfoError> failList = new ArrayList<>();
        TEmployedPeopleInfoError employedPeopleInfoError;
        TEmployedPeopleInfo tEmployedPeopleInfoForInsert;
        StringBuilder stringBuilder;
        for (TEmployedPeopleInfoError tEmployedPeopleInfo : employedPeopleInfos){
            stringBuilder = new StringBuilder();

            try {
                if (tEmployedPeopleInfo.getEmployedPeopleName() == null || "".equals(tEmployedPeopleInfo.getEmployedPeopleName())) {
                    stringBuilder.append("姓名为空|");
                }

                if (tEmployedPeopleInfo.getIdCard() == null || "".equals(tEmployedPeopleInfo.getIdCard())) {
                    stringBuilder.append("身份证为空|");
                }

                if (tEmployedPeopleInfo.getBeyondEnterpriseName() == null || "".equals(tEmployedPeopleInfo.getBeyondEnterpriseName())) {
                    stringBuilder.append("企业信息为空|");
                }

                List<TEnterpriseInfo> tEnterpriseInfos = enterpriseInfoMapper.selectTEnterpriseInfoByName(tEmployedPeopleInfo.getBeyondEnterpriseName());
                if (tEnterpriseInfos == null) {
                    stringBuilder.append("关联企业信息不存在|");
                }

                // 如果没有错误信息，则判断是否是之前错误的数据，如果是的话，则把之前错误的数据删除
                if (tEmployedPeopleInfo.getEmployedPeopleErrorId() != null) {
                    employedPeopleInfoErrorMapper.deleteTEmployedPeopleInfoErrorById(tEmployedPeopleInfo.getEmployedPeopleErrorId());
                }
                if(!"".equals(stringBuilder.toString())) {
                    employedPeopleInfoError = new TEmployedPeopleInfoError();
                    BeanUtils.copyProperties(tEmployedPeopleInfo, employedPeopleInfoError);
                    employedPeopleInfoError.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserId() + "");
                    employedPeopleInfoError.setErrorMsg(stringBuilder.toString());
                    failList.add(employedPeopleInfoError);
                    continue;
                }

                tEmployedPeopleInfoForInsert = new TEmployedPeopleInfo();
                BeanUtils.copyProperties(tEmployedPeopleInfo,tEmployedPeopleInfoForInsert);
                SysUser user = SecurityUtils.getLoginUser().getUser();
                tEmployedPeopleInfoForInsert.setCreateBy(user.getUserName());
                tEmployedPeopleInfoForInsert.setCreateTime(new Date());
                tEmployedPeopleInfoForInsert.setUpdateTime(new Date());
                tEmployedPeopleInfoForInsert.setUpdateBy(user.getUserName());

                this.insertTEmployedPeopleInfo(tEmployedPeopleInfoForInsert);
            } catch (Exception e) {
                throw new BaseException("导入出错");
            }
        }

        if (failList.size() > 0) {
            employedPeopleInfoErrorMapper.batchInsertTEmployedPeopleInfoError(failList);
        }

        return "导入完成";
    }
    /**
     * 查询当前用户导入 从业人员的错误数据总数
     * @return int
     */
    @Override
    public int countImportError() {

        Long userId = SecurityUtils.getLoginUser().getUser().getUserId();

        return employedPeopleInfoErrorMapper.countByCreateByInt(userId + "");
    }



    /**
     * 查询人员类型分组
     * @return r
     */
    @Override
    public List<String> queryPeopleOccupationByGroupBy() {
        return tEmployedPeopleInfoMapper.queryPeopleOccupationByGroupBy();
    }
}
