package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.*;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.SysSetting;
import com.zehong.system.domain.TConGasProInfor;
import com.zehong.system.domain.TPipeOldPlanProcess;
import com.zehong.system.domain.vo.TConGasProInforVo;
import com.zehong.system.mapper.TConGasProInforMapper;
import com.zehong.system.service.ISysSettingService;
import com.zehong.system.service.ITConGasProInforService;
import com.zehong.system.service.ITSerialNumberInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 第三方施工-涉气第三方施工项目档案Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-26
 */
@Service
public class TConGasProInforServiceImpl implements ITConGasProInforService 
{
    private static final Logger log = LoggerFactory.getLogger(TConGasProInforServiceImpl.class);

    @Resource
    private TConGasProInforMapper tConGasProInforMapper;

    @Resource
    private ISysSettingService sysSettingService;

    @Resource
    private ITSerialNumberInfoService itSerialNumberInfoService;

    @Resource
    private GovernmentDataUtil governmentDataUtil;

    /**
     * 查询第三方施工-涉气第三方施工项目档案
     * 
     * @param fConGasProInforId 第三方施工-涉气第三方施工项目档案ID
     * @return 第三方施工-涉气第三方施工项目档案
     */
    @Override
    public TConGasProInfor selectTConGasProInforById(Long fConGasProInforId)
    {
        return tConGasProInforMapper.selectTConGasProInforById(fConGasProInforId);
    }

    /**
     * 查询第三方施工-涉气第三方施工项目档案列表
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 第三方施工-涉气第三方施工项目档案
     */
    @Override
    public List<TConGasProInfor> selectTConGasProInforList(TConGasProInfor tConGasProInfor)
    {
        SysRole sysRole = SecurityUtils.getLoginUser().getUser().getRoles().get(0);
        if (sysRole.getRoleId() != 1 && sysRole.getRoleId() != 5) {
            tConGasProInfor.setEntUploadState("1");
        }

        return tConGasProInforMapper.selectTConGasProInforList(tConGasProInfor);
    }


    /**
     * 查询第三方施工-涉气第三方施工项目档案列表
     *
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 第三方施工-涉气第三方施工项目档案
     */
    @Override
    public List<TConGasProInfor> exportTConGasProInforList(TConGasProInfor tConGasProInfor)
    {

        LoginUser loginUser = SecurityUtils.getLoginUser();

        // 如果是 政府端 则 把 govUploadState 赋值给 entUploadState, 把 govUploadTime 赋值给 entUploadTime
        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
            tConGasProInfor.setEntUploadState("1");
        }

        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
            ExcelUtil.hiddencolumns.add(36);
            ExcelUtil.hiddencolumns.add(37);
        }

        if(loginUser.getUser().getRoles().get(0).getRoleId()==5){
            ExcelUtil.hiddencolumns.add(38);
            ExcelUtil.hiddencolumns.add(39);
        }
        return tConGasProInforMapper.exportTConGasProInforList(tConGasProInfor);
    }

    /**
     * 新增第三方施工-涉气第三方施工项目档案
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 结果
     */
    @Override
    public int insertTConGasProInfor(TConGasProInfor tConGasProInfor)
    {
        SysSetting code = sysSettingService.getSystemValueByKey("city_id");
        if(null == code || StringUtils.isEmpty(code.getSystemValue())) throw new CustomException("行政编码未配置！");
        Map<String,String> num = itSerialNumberInfoService.getSerialNumberByTableType("t_con_gas_pro_infor");
        if(null == num || StringUtils.isEmpty(num.get("f_project_code"))) throw new CustomException("项目档案项目编码未配置！");
        tConGasProInfor.setfProjectCode(code.getSystemValue()+ Year.now().getValue() + num.get("f_project_code"));
        tConGasProInfor.setfUpdateTime(DateUtils.getTime());
        return tConGasProInforMapper.insertTConGasProInfor(tConGasProInfor);
    }

    /**
     * 修改第三方施工-涉气第三方施工项目档案
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 结果
     */
    @Override
    public int updateTConGasProInfor(TConGasProInfor tConGasProInfor){
        tConGasProInfor.setfUpdateTime(DateUtils.getTime());
        return tConGasProInforMapper.updateTConGasProInfor(tConGasProInfor);
    }

    /**
     * 批量删除第三方施工-涉气第三方施工项目档案
     * 
     * @param fConGasProInforIds 需要删除的第三方施工-涉气第三方施工项目档案ID
     * @return 结果
     */
    @Override
    public int deleteTConGasProInforByIds(Long[] fConGasProInforIds)
    {
        return tConGasProInforMapper.deleteTConGasProInforByIds(fConGasProInforIds);
    }

    /**
     * 删除第三方施工-涉气第三方施工项目档案信息
     * 
     * @param fConGasProInforId 第三方施工-涉气第三方施工项目档案ID
     * @return 结果
     */
    @Override
    public int deleteTConGasProInforById(Long fConGasProInforId)
    {
        return tConGasProInforMapper.deleteTConGasProInforById(fConGasProInforId);
    }

    /**
     * 政府端上传第三方施工
     * @param fConGasProInforId 第三方施工id
     * @return
     */
    @Override
    public int reportConGasProInfo(Long fConGasProInforId) throws Exception {
        TConGasProInfor conGasProInfor = tConGasProInforMapper.selectTConGasProInforById(fConGasProInforId);
        TConGasProInforVo conGasProInforVo = new TConGasProInforVo();
        GovernmentDataCopyUtil.copyToGovernData(conGasProInfor,conGasProInforVo);
        conGasProInforVo.setConstructionPoint(conGasProInfor.getfConstructionLatitude() + "、" + conGasProInfor.getfConstructionLongitude());
        List<TConGasProInforVo> data = new ArrayList<>();
        data.add(conGasProInforVo);
        JSONObject reportResult = governmentDataUtil.setInfo("construction/gas/project/information","WRITE",data);
        log.info("上传第三方施工结果===================" + reportResult.toJSONString());
        if(!"0".equals(reportResult.getString("resultCode"))) throw new CustomException("上传第三方施工接口失败");
        conGasProInfor.setGovUploadState("1");
        conGasProInfor.setGovUploadTime(new Date());
        tConGasProInforMapper.updateTConGasProInfor(conGasProInfor);
        return 1;
    }

    /**
     * 企业端上传数据
     * @param fConGasProInforId id
     * @return
     */
    @Override
    public int entReportConGasProInfo(Long fConGasProInforId) {
        tConGasProInforMapper.updateEntUploadStateById("1",new Date(),fConGasProInforId);
        return 1;
    }
}
