package com.zehong.system.service.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.excel.EasyExcel;
import com.zehong.common.core.domain.entity.SysDictData;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.config.easyexcel.CustomCellWriteHeightConfig;
import com.zehong.system.config.easyexcel.CustomCellWriteWidthConfig;
import com.zehong.system.domain.TComplainDealManSysSet;
import com.zehong.system.domain.dto.TComplainDealDTO;
import com.zehong.system.domain.vo.ComplainDealSummaryAnalysisTableVo;
import com.zehong.system.domain.vo.ComplainDealSummaryAnalysisVo;
import com.zehong.system.domain.vo.HomepageVo;
import com.zehong.system.mapper.SysDictDataMapper;
import com.zehong.system.mapper.TComplainDealManSysSetMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TComplainDealMapper;
import com.zehong.system.domain.TComplainDeal;
import com.zehong.system.service.ITComplainDealService;

import javax.servlet.http.HttpServletResponse;

/**
 * 投诉处置Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-15
 */
@Service("complainDealServiceImpl")
public class TComplainDealServiceImpl implements ITComplainDealService 
{
    @Autowired
    private TComplainDealMapper tComplainDealMapper;

    @Autowired
    private TComplainDealManSysSetMapper tComplainDealManSysSetMapper;

    @Autowired
    private SysDictDataMapper sysDictDataMapper;

    /**
     * 查询投诉处置
     * 
     * @param complainDealId 投诉处置ID
     * @return 投诉处置
     */
    @Override
    public TComplainDeal selectTComplainDealById(Long complainDealId)
    {
        return tComplainDealMapper.selectTComplainDealById(complainDealId);
    }

    /**
     * 查询投诉处置列表
     * 
     * @param tComplainDeal 投诉处置
     * @return 投诉处置
     */
    @Override
    public List<TComplainDeal> selectTComplainDealList(TComplainDeal tComplainDeal)
    {
        return tComplainDealMapper.selectTComplainDealList(tComplainDeal);
    }

    /**
     * 投诉处置统计
     *
     * @return 投诉处置统计
     */
    public HomepageVo countTComplainDeal()
    {
        return tComplainDealMapper.countTComplainDeal();
    }

    /**
     * 新增投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    @Override
    public int insertTComplainDeal(TComplainDeal tComplainDeal)
    {
        tComplainDeal.setCreateTime(DateUtils.getNowDate());
        return tComplainDealMapper.insertTComplainDeal(tComplainDeal);
    }

    /**
     * 修改投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    @Override
    public int updateTComplainDeal(TComplainDeal tComplainDeal)
    {
        tComplainDeal.setUpdateTime(DateUtils.getNowDate());
        return tComplainDealMapper.updateTComplainDeal(tComplainDeal);
    }

    /**
     * 批量删除投诉处置
     * 
     * @param complainDealIds 需要删除的投诉处置ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealByIds(Long[] complainDealIds)
    {
        return tComplainDealMapper.deleteTComplainDealByIds(complainDealIds);
    }

    /**
     * 删除投诉处置信息
     * 
     * @param complainDealId 投诉处置ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealById(Long complainDealId)
    {
        return tComplainDealMapper.deleteTComplainDealById(complainDealId);
    }
    @Override
    public  List<Map<String,Object>> selectUserByenterproseId(String enterproseId){
        return tComplainDealMapper.selectUserByenterproseId(enterproseId);
    }

    /**
     * 投诉处置 统计分析 table 方式 方法
     * @return list
     */
    @Override
    public List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisMethodTableViews(ComplainDealSummaryAnalysisTableVo complainDealSummaryAnalysisTableVo) {

        // 管理制度
        List<TComplainDealManSysSet> tComplainDealManSysSets = tComplainDealManSysSetMapper.selectTComplainDealManSysSetList(new TComplainDealManSysSet());

        //1-投诉举报 管理制度时间
        long fType1 = 0;
        //2-服务申请 管理制度时间
        long fType2 = 0;
        //3-咨询建议 管理制度时间
        long fType3 = 0;

        //总发生量
        BigDecimal totalAmount = BigDecimal.ZERO;

        //总办结量
        BigDecimal totalCompletionRate = BigDecimal.ZERO;

        //总及时办结量
        BigDecimal totalTimelyCompletionRate = BigDecimal.ZERO;

        for (TComplainDealManSysSet tComplainDealManSysSet : tComplainDealManSysSets) {
            Long days = tComplainDealManSysSet.getfDay();
            Long hours = tComplainDealManSysSet.getfHours();
            Long minutes = tComplainDealManSysSet.getfMinutes();
            Long seconds = tComplainDealManSysSet.getfSeconds();
            Long allTime = days * 24L * 60 * 60 * 1000
                    + hours * 60 * 60 * 1000
                    + minutes * 60 * 1000
                    + seconds * 1000;
            if ("1".equals(tComplainDealManSysSet.getfType())) {
                fType1= allTime;
            } else if ("2".equals(tComplainDealManSysSet.getfType())) {
                fType2= allTime;
            } else if ("3".equals(tComplainDealManSysSet.getfType())) {
                fType3 = allTime;
            }
        }

        String date1 = complainDealSummaryAnalysisTableVo.getDate();
        if(StringUtils.isEmpty(date1)) {
            return initEmptyList();
        }

        //查询当前年的开始时间和结束时间
        Date startOfMonth = DateUtils.parseDate(date1 + "-01-01 00:00:00");
        Date endOfMonth = DateUtils.parseDate(date1 + "-12-31 23:59:59");;
        String complaintCategory = complainDealSummaryAnalysisTableVo.getComplainType();

        //所有所有发生的投诉
        List<TComplainDealDTO> tComplainDeals = tComplainDealMapper.queryAllByNotDeleteAndCreateTime(startOfMonth,endOfMonth,complaintCategory);

        List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisTableVos = new ArrayList<>();

        //先初始化一个空的，然后再循环往里面放值
        List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisTableVosEmpty = initEmptyList();
        //如果没数据，就返回一个都是null的数据的集合
        if(tComplainDeals.size() == 0) {
            return complainDealSummaryAnalysisTableVosEmpty;
        }

        Map<String, List<TComplainDealDTO>> collect = tComplainDeals.stream().collect(Collectors.groupingBy(TComplainDealDTO::getCreateTimeYear));
        ComplainDealSummaryAnalysisTableVo complainDealSummaryAnalysisTableVo1;
        for (Map.Entry<String, List<TComplainDealDTO>> stringListEntry : collect.entrySet()) {
            String key = stringListEntry.getKey();
            List<TComplainDealDTO> value = stringListEntry.getValue();
            BigDecimal count = new BigDecimal(value.size());

            // 发生量统计
            totalAmount = totalAmount.add(count);

            complainDealSummaryAnalysisTableVo1 = new ComplainDealSummaryAnalysisTableVo();
            complainDealSummaryAnalysisTableVo1.setDate(key + "月");
            // 发生量
            complainDealSummaryAnalysisTableVo1.setAmount(value.size() + "");

            // 如果有发生量
            if (value.size() > 0) {
                //办结率
                List<TComplainDealDTO> completionRateCollect = value.stream().filter(item -> "3".equals(item.getComplainStatus())).collect(Collectors.toList());

                if (completionRateCollect.size() == 0) {
                    complainDealSummaryAnalysisTableVo1.setCompletionRate("0");
                } else {
                    BigDecimal completedCount = new BigDecimal(completionRateCollect.size());

                    BigDecimal divide = completedCount.multiply(new BigDecimal(100)).divide(count, 2, BigDecimal.ROUND_HALF_UP);

                    //统计 发生率
                    totalCompletionRate = totalCompletionRate.add(completedCount);

                    complainDealSummaryAnalysisTableVo1.setCompletionRate(divide.toString());
                }

                // 及时办结率
                if( completionRateCollect.size() == 0) {
                    complainDealSummaryAnalysisTableVo1.setTimelyCompletionRate("0");
                } else {
                    int timelyCompletionRateInt = 0;
                    for (TComplainDealDTO tComplainDealDTO : completionRateCollect) {
                        String complainType = tComplainDealDTO.getComplainType();
                        Date createTime = tComplainDealDTO.getCreateTime();
                        Date updateTime = tComplainDealDTO.getUpdateTime();

                        if (complainType != null && !"".equals(complainType)
                                && createTime != null && updateTime != null) {
                            long diff = updateTime.getTime() - createTime.getTime();

                            // 是类型1 并且小于 类型1的管理制度
                            if ("1".equals(complainType)) {
                                if (diff - fType1 < 0) {
                                    timelyCompletionRateInt ++;
                                }
                            } else if ("2".equals(complainType)) {
                                if (diff - fType2 < 0) {
                                    timelyCompletionRateInt ++;
                                }
                            } else if ("3".equals(complainType)) {
                                if (diff - fType3 < 0) {
                                    timelyCompletionRateInt ++;
                                }
                            }
                        }
                    }

                    if (timelyCompletionRateInt > 0) {
                        BigDecimal CompletionRateIntDecimal = new BigDecimal(timelyCompletionRateInt);

                        BigDecimal divide = CompletionRateIntDecimal.multiply(new BigDecimal(100)).divide(count, 2, BigDecimal.ROUND_HALF_UP);

                        //统计 及时办结率
                        totalTimelyCompletionRate = totalTimelyCompletionRate.add(CompletionRateIntDecimal);

                        complainDealSummaryAnalysisTableVo1.setTimelyCompletionRate(divide.toString());
                    } else {
                        complainDealSummaryAnalysisTableVo1.setTimelyCompletionRate("0");
                    }
                }
                // 如果没有发生量则别的都是0
            } else {
                complainDealSummaryAnalysisTableVo1.setCompletionRate("0");
                complainDealSummaryAnalysisTableVo1.setTimelyCompletionRate("0");
            }

            complainDealSummaryAnalysisTableVos.add(complainDealSummaryAnalysisTableVo1);
        }
        // 如果有数据，则往 empty集合里面放值
        if (complainDealSummaryAnalysisTableVos.size() > 0) {
            for (int i = 0; i < complainDealSummaryAnalysisTableVosEmpty.size(); i++) {
                ComplainDealSummaryAnalysisTableVo dealSummaryAnalysisTableVo = complainDealSummaryAnalysisTableVosEmpty.get(i);
                for (ComplainDealSummaryAnalysisTableVo summaryAnalysisTableVo : complainDealSummaryAnalysisTableVos) {
                    if (dealSummaryAnalysisTableVo.getDate().equals(summaryAnalysisTableVo.getDate())) {
                        dealSummaryAnalysisTableVo.setAmount(summaryAnalysisTableVo.getAmount());
                        dealSummaryAnalysisTableVo.setCompletionRate(summaryAnalysisTableVo.getCompletionRate());
                        dealSummaryAnalysisTableVo.setTimelyCompletionRate(summaryAnalysisTableVo.getTimelyCompletionRate());
                    }
                }

                //说明是 统计
                if (i == 12 ) {
                    dealSummaryAnalysisTableVo.setAmount(totalAmount.toString());

                    // 统计 办结率
                    BigDecimal divide = totalCompletionRate.multiply(new BigDecimal(100)).divide(totalAmount, 2, BigDecimal.ROUND_HALF_UP);
                    dealSummaryAnalysisTableVo.setCompletionRate(divide.toString());

                    // 统计 及时办结率
                    BigDecimal divide1 = totalTimelyCompletionRate.multiply(new BigDecimal(100)).divide(totalAmount, 2, BigDecimal.ROUND_HALF_UP);
                    dealSummaryAnalysisTableVo.setTimelyCompletionRate(divide1.toString());
                }
            }
        }
        return complainDealSummaryAnalysisTableVosEmpty;
    }

    private List<ComplainDealSummaryAnalysisTableVo> initEmptyList() {
        List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisTableVos = new ArrayList<>(13);
        ComplainDealSummaryAnalysisTableVo complainDealSummaryAnalysisTableVo;
        for (int i = 0; i < 13; i++) {
            complainDealSummaryAnalysisTableVo = new ComplainDealSummaryAnalysisTableVo();
            if (i <12) {
                complainDealSummaryAnalysisTableVo.setDate((i + 1) + "月");
            } else {
                complainDealSummaryAnalysisTableVo.setDate("统计");
            }
            complainDealSummaryAnalysisTableVo.setAmount(null);
            complainDealSummaryAnalysisTableVo.setCompletionRate(null);
            complainDealSummaryAnalysisTableVo.setTimelyCompletionRate(null);
            complainDealSummaryAnalysisTableVos.add(complainDealSummaryAnalysisTableVo);
        }
        return complainDealSummaryAnalysisTableVos;
    }

    /**
     * 统计分析导出
     * @param complainDealSummaryAnalysisTableVo c
     */
    @Override
    public void complainDealSummaryAnalysisExport(HttpServletResponse response, ComplainDealSummaryAnalysisTableVo complainDealSummaryAnalysisTableVo) throws IOException {
        List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisTableVos = complainDealSummaryAnalysisMethodTableViews(complainDealSummaryAnalysisTableVo);
        // 设置动态头
        String dynamicTitle = complainDealSummaryAnalysisTableVo.getDynamicTitle();
        List<List<String>> headList = new ArrayList<>();
        List<String> head0 = new ArrayList<>();
        head0.add(dynamicTitle);
        head0.add("日期");
        List<String> head1 = new ArrayList<>();
        head1.add(dynamicTitle);
        head1.add("发生量");
        List<String> head2 = new ArrayList<>();
        head2.add(dynamicTitle);
        head2.add("办结率");
        List<String> head3 = new ArrayList<>();
        head3.add(dynamicTitle);
        head3.add("办结及时率");
        headList.add(head0);
        headList.add(head1);
        headList.add(head2);
        headList.add(head3);

        List<List<Object>> dataList = complainDealSummaryAnalysisTableVos.stream().map(vo -> {
            List<Object> objectList = new ArrayList<>();
            objectList.add(vo.getDate());
            objectList.add(vo.getAmount());
            objectList.add(vo.getCompletionRate());
            objectList.add(vo.getTimelyCompletionRate());
            return objectList;
        }).collect(Collectors.toList());

        // 设置响应头
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        // 设置防止中文名乱码
        String filename = URLEncoder.encode("投诉汇总分析", "utf-8");
        response.setHeader("content-disposition", "attachment;filename=" + filename + ".xlsx");

        // 先仅仅写入头，再以不写入头的方式写入数据
        EasyExcel.write(response.getOutputStream())
                .registerWriteHandler(new CustomCellWriteHeightConfig())
                .registerWriteHandler(new CustomCellWriteWidthConfig()).head(headList).sheet("投诉汇总分析列表").doWrite(dataList);
    }

    /**
     * 投诉处置 统计分析 echart 方式 方法
     * @return
     */
    @Override
    public ComplainDealSummaryAnalysisVo complainDealSummaryAnalysisMethod() {

        ComplainDealSummaryAnalysisVo complainDealSummaryAnalysisVo = new ComplainDealSummaryAnalysisVo();
        /*
         * 类型 发生量统计分析*/
        List<Map<String,String>> typeOfNumberOfComplaints = new ArrayList<>();
        /*
         * 区域 发生量统计分析*/
        List<Map<String,String>> regionOfNumberOfComplaints = new ArrayList<>();
        /*
         * 类型 办结率分析*/
        List<Map<String,String>> typeOfCompletionRate = new ArrayList<>();
        /*
         * 区域 办结率分析*/
        List<Map<String,String>> regionOfCompletionRate = new ArrayList<>();
        /*
         * 类型 办结及时率分析*/
        List<Map<String,String>> typeOfTimelyCompletionRate = new ArrayList<>();
        /*
         * 区域 办结及时率分析*/
        List<Map<String,String>> regionOfTimelyCompletionRate = new ArrayList<>();

        // 管理制度
        List<TComplainDealManSysSet> tComplainDealManSysSets = tComplainDealManSysSetMapper.selectTComplainDealManSysSetList(new TComplainDealManSysSet());

        List<SysDictData> t_township = sysDictDataMapper.selectDictDataByType("t_township");

        //1-投诉举报 管理制度时间
        long fType1 = 0;
        //2-服务申请 管理制度时间
        long fType2 = 0;
        //3-咨询建议 管理制度时间
        long fType3 = 0;

        for (TComplainDealManSysSet tComplainDealManSysSet : tComplainDealManSysSets) {
            Long days = tComplainDealManSysSet.getfDay();
            Long hours = tComplainDealManSysSet.getfHours();
            Long minutes = tComplainDealManSysSet.getfMinutes();
            Long seconds = tComplainDealManSysSet.getfSeconds();
            Long allTime = days * 24L * 60 * 60 * 1000
                    + hours * 60 * 60 * 1000
                    + minutes * 60 * 1000
                    + seconds * 1000;
            if ("1".equals(tComplainDealManSysSet.getfType())) {
                fType1= allTime;
            } else if ("2".equals(tComplainDealManSysSet.getfType())) {
                fType2= allTime;
            } else if ("3".equals(tComplainDealManSysSet.getfType())) {
                fType3 = allTime;
            }
        }

        //所有所有发生的投诉
        List<TComplainDeal> tComplainDeals = tComplainDealMapper.queryAllByNotDelete();
        if (tComplainDeals.size() > 0) {

            Map<String,String> itemMap;
            // 先过滤调 区域不为空的
            List<TComplainDeal> townShipNotEmptyList = tComplainDeals.stream().filter(item -> item.getTownship() != null).collect(Collectors.toList());
            if(townShipNotEmptyList.size() > 0) {
                //区域分组
                Map<String, List<TComplainDeal>> townShipCollect = townShipNotEmptyList.stream().collect(Collectors.groupingBy(TComplainDeal::getTownship));

                if(townShipCollect.size() > 0) {
                    for (Map.Entry<String, List<TComplainDeal>> stringListEntry : townShipCollect.entrySet()) {
                        String key = stringListEntry.getKey();
                        for (SysDictData sysDictData : t_township) {
                            if (sysDictData.getDictValue().equals(key)) {
                                key = sysDictData.getDictLabel();
                            }
                        }
                        List<TComplainDeal> value = stringListEntry.getValue();

                        // 总量
                        itemMap = new HashMap<>();
                        itemMap.put("name", key);
                        itemMap.put("value", value.size() + "");
                        regionOfNumberOfComplaints.add(itemMap);
                        BigDecimal count = new BigDecimal(value.size());

                        // 办结率 - 完成的占比
                        List<TComplainDeal> collect = value.stream().filter(item -> "3".equals(item.getComplainStatus())).collect(Collectors.toList());
                        itemMap = new HashMap<>();
                        itemMap.put("name", key);
                        if (collect.size() == 0) {
                            itemMap.put("value", "0");
                        } else {

                            BigDecimal completedCount = new BigDecimal(collect.size());

                            BigDecimal divide = completedCount.multiply(new BigDecimal(100)).divide(count, 2, BigDecimal.ROUND_HALF_UP);

                            itemMap.put("value", divide.toString());

                        }
                        regionOfCompletionRate.add(itemMap);

                        // 办结及时率 - 完成的在 制度时间内的占比
                        itemMap = new HashMap<>();
                        itemMap.put("name", key);
                        if (collect.size() == 0) {
                            itemMap.put("value", "0");
                        } else {
                            int timelyCompletionRateInt = 0;
                            for (TComplainDeal tComplainDeal : collect) {
                                String complainType = tComplainDeal.getComplainType();
                                Date createTime = tComplainDeal.getCreateTime();
                                Date updateTime = tComplainDeal.getUpdateTime();

                                if (complainType != null && !"".equals(complainType)
                                        && createTime != null && updateTime != null) {
                                    long diff = updateTime.getTime() - createTime.getTime();

                                    // 是类型1 并且小于 类型1的管理制度
                                    if ("1".equals(complainType)) {
                                        if (diff - fType1 < 0) {
                                            timelyCompletionRateInt ++;
                                            continue;
                                        }
                                    } else if ("2".equals(complainType)) {
                                        if (diff - fType2 < 0) {
                                            timelyCompletionRateInt ++;
                                            continue;
                                        }
                                    } else if ("3".equals(complainType)) {
                                        if (diff - fType3 < 0) {
                                            timelyCompletionRateInt ++;
                                            continue;
                                        }
                                    }

                                    if (timelyCompletionRateInt > 0) {
                                        BigDecimal CompletionRateIntDecimal = new BigDecimal(timelyCompletionRateInt);

                                        BigDecimal divide = CompletionRateIntDecimal.multiply(new BigDecimal(100)).divide(count, 2, BigDecimal.ROUND_HALF_UP);

                                        itemMap.put("value", divide.toString());
                                    } else {
                                        itemMap.put("value", "0");
                                    }
                                } else {
                                    itemMap.put("value", "0");
                                }
                            }
                        }
                        regionOfTimelyCompletionRate.add(itemMap);
                    }
                }

            }

            List<TComplainDeal> complainTypeNotEmptyList = tComplainDeals.stream().filter(item -> item.getComplainType() != null).collect(Collectors.toList());
            if (complainTypeNotEmptyList.size() > 0) {

                //类型分组
                Map<String, List<TComplainDeal>> typeCollect = complainTypeNotEmptyList.stream().collect(Collectors.groupingBy(TComplainDeal::getComplainType));

                //类型分类 一共三种 循环循环三次
                if (typeCollect.size() > 0) {
                    for (Map.Entry<String, List<TComplainDeal>> stringListEntry : typeCollect.entrySet()) {
                        String key = stringListEntry.getKey();
                        List<TComplainDeal> value = stringListEntry.getValue();
                        if ("1".equals(key)) {
                            key = "投诉举报";
                        } else if ("2".equals(key)) {
                            key = "服务申请";
                        } else if ("3".equals(key)) {
                            key = "咨询建议";
                        }

                        // 总量
                        itemMap = new HashMap<>();
                        itemMap.put("name", key);
                        itemMap.put("value", value.size() + "");
                        typeOfNumberOfComplaints.add(itemMap);
                        BigDecimal count = new BigDecimal(value.size());

                        // 办结率 - 完成的占比
                        List<TComplainDeal> collect = value.stream().filter(item -> "3".equals(item.getComplainStatus())).collect(Collectors.toList());
                        itemMap = new HashMap<>();
                        itemMap.put("name", key);
                        if (collect.size() == 0) {
                            itemMap.put("value", "0");
                        } else {

                            BigDecimal completedCount = new BigDecimal(collect.size());

                            BigDecimal divide = completedCount.multiply(new BigDecimal(100)).divide(count, 2, BigDecimal.ROUND_HALF_UP);

                            itemMap.put("value", divide.toString());

                        }
                        typeOfCompletionRate.add(itemMap);

                        // 办结及时率 - 完成的在 制度时间内的占比
                        itemMap = new HashMap<>();
                        itemMap.put("name", key);
                        if (collect.size() == 0) {
                            itemMap.put("value", "0");
                        } else {
                            int timelyCompletionRateInt = 0;
                            for (TComplainDeal tComplainDeal : collect) {
                                Date createTime = tComplainDeal.getCreateTime();
                                Date updateTime = tComplainDeal.getUpdateTime();

                                if (createTime != null && updateTime != null) {
                                    long diff = updateTime.getTime() - createTime.getTime();

                                    // 是类型1 并且小于 类型1的管理制度
                                    if ("1".equals(key)) {
                                        if (diff - fType1 < 0) {
                                            timelyCompletionRateInt ++;
                                            continue;
                                        }
                                    } else if ("2".equals(key)) {
                                        if (diff - fType2 < 0) {
                                            timelyCompletionRateInt ++;
                                            continue;
                                        }
                                    } else if ("3".equals(key)) {
                                        if (diff - fType3 < 0) {
                                            timelyCompletionRateInt ++;
                                            continue;
                                        }
                                    }

                                    if (timelyCompletionRateInt > 0) {
                                        BigDecimal completionRateIntDecimal = new BigDecimal(timelyCompletionRateInt);

                                        BigDecimal divide = completionRateIntDecimal.multiply(new BigDecimal(100)).divide(count, 2, BigDecimal.ROUND_HALF_UP);

                                        itemMap.put("value", divide.toString());
                                    } else {
                                        itemMap.put("value", "0");
                                    }
                                } else {
                                    itemMap.put("value", "0");
                                }
                            }
                        }
                        typeOfTimelyCompletionRate.add(itemMap);
                    }
                }
            }
        }

        complainDealSummaryAnalysisVo.setRegionOfNumberOfComplaints(regionOfNumberOfComplaints);
        complainDealSummaryAnalysisVo.setTypeOfNumberOfComplaints(typeOfNumberOfComplaints);
        complainDealSummaryAnalysisVo.setRegionOfCompletionRate(regionOfCompletionRate);
        complainDealSummaryAnalysisVo.setTypeOfCompletionRate(typeOfCompletionRate);
        complainDealSummaryAnalysisVo.setRegionOfTimelyCompletionRate(regionOfTimelyCompletionRate);
        complainDealSummaryAnalysisVo.setTypeOfTimelyCompletionRate(typeOfTimelyCompletionRate);

        return complainDealSummaryAnalysisVo;
    }


    /**
     *
     * @param dataSourceName ureport2配置数据源名称
     * @param dataSetName ureport2配置数据集明恒
     * @param map 参数map
     * @return
     */
    @Override
    public List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisMethodTableViewsForUrepore2(String dataSourceName,String dataSetName,Map<String,String> map) {

        String date = map.get("date");
        String complaintCategory = map.get("complaintCategory");

        // 管理制度
        List<TComplainDealManSysSet> tComplainDealManSysSets = tComplainDealManSysSetMapper.selectTComplainDealManSysSetList(new TComplainDealManSysSet());

        //1-投诉举报 管理制度时间
        long fType1 = 0;
        //2-服务申请 管理制度时间
        long fType2 = 0;
        //3-咨询建议 管理制度时间
        long fType3 = 0;

        //总发生量
        BigDecimal totalAmount = BigDecimal.ZERO;

        //总办结量
        BigDecimal totalCompletionRate = BigDecimal.ZERO;

        //总及时办结量
        BigDecimal totalTimelyCompletionRate = BigDecimal.ZERO;

        for (TComplainDealManSysSet tComplainDealManSysSet : tComplainDealManSysSets) {
            Long days = tComplainDealManSysSet.getfDay();
            Long hours = tComplainDealManSysSet.getfHours();
            Long minutes = tComplainDealManSysSet.getfMinutes();
            Long seconds = tComplainDealManSysSet.getfSeconds();
            Long allTime = days * 24L * 60 * 60 * 1000
                    + hours * 60 * 60 * 1000
                    + minutes * 60 * 1000
                    + seconds * 1000;
            if ("1".equals(tComplainDealManSysSet.getfType())) {
                fType1= allTime;
            } else if ("2".equals(tComplainDealManSysSet.getfType())) {
                fType2= allTime;
            } else if ("3".equals(tComplainDealManSysSet.getfType())) {
                fType3 = allTime;
            }
        }

        if(StringUtils.isEmpty(date)) {
            return initEmptyList();
        }

        //查询当前年的开始时间和结束时间
        Date startOfMonth = DateUtils.parseDate(date + "-01-01 00:00:00");
        Date endOfMonth = DateUtils.parseDate(date + "-12-31 23:59:59");

        //所有所有发生的投诉
        List<TComplainDealDTO> tComplainDeals = tComplainDealMapper.queryAllByNotDeleteAndCreateTime(startOfMonth,endOfMonth,complaintCategory);

        List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisTableVos = new ArrayList<>();

        //先初始化一个空的，然后再循环往里面放值
        List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisTableVosEmpty = initEmptyList();
        //如果没数据，就返回一个都是null的数据的集合
        if(tComplainDeals.size() == 0) {
            return complainDealSummaryAnalysisTableVosEmpty;
        }

        Map<String, List<TComplainDealDTO>> collect = tComplainDeals.stream().collect(Collectors.groupingBy(TComplainDealDTO::getCreateTimeYear));
        ComplainDealSummaryAnalysisTableVo complainDealSummaryAnalysisTableVo1;
        for (Map.Entry<String, List<TComplainDealDTO>> stringListEntry : collect.entrySet()) {
            String key = stringListEntry.getKey();
            List<TComplainDealDTO> value = stringListEntry.getValue();
            BigDecimal count = new BigDecimal(value.size());

            // 发生量统计
            totalAmount = totalAmount.add(count);

            complainDealSummaryAnalysisTableVo1 = new ComplainDealSummaryAnalysisTableVo();
            complainDealSummaryAnalysisTableVo1.setDate(key + "月");
            // 发生量
            complainDealSummaryAnalysisTableVo1.setAmount(value.size() + "");

            // 如果有发生量
            if (value.size() > 0) {
                //办结率
                List<TComplainDealDTO> completionRateCollect = value.stream().filter(item -> "3".equals(item.getComplainStatus())).collect(Collectors.toList());

                if (completionRateCollect.size() == 0) {
                    complainDealSummaryAnalysisTableVo1.setCompletionRate("0");
                } else {
                    BigDecimal completedCount = new BigDecimal(completionRateCollect.size());

                    BigDecimal divide = completedCount.multiply(new BigDecimal(100)).divide(count, 2, BigDecimal.ROUND_HALF_UP);

                    //统计 发生率
                    totalCompletionRate = totalCompletionRate.add(completedCount);

                    complainDealSummaryAnalysisTableVo1.setCompletionRate(divide.toString());
                }

                // 及时办结率
                if( completionRateCollect.size() == 0) {
                    complainDealSummaryAnalysisTableVo1.setTimelyCompletionRate("0");
                } else {
                    int timelyCompletionRateInt = 0;
                    for (TComplainDealDTO tComplainDealDTO : completionRateCollect) {
                        String complainType = tComplainDealDTO.getComplainType();
                        Date createTime = tComplainDealDTO.getCreateTime();
                        Date updateTime = tComplainDealDTO.getUpdateTime();

                        if (complainType != null && !"".equals(complainType)
                                && createTime != null && updateTime != null) {
                            long diff = updateTime.getTime() - createTime.getTime();

                            // 是类型1 并且小于 类型1的管理制度
                            if ("1".equals(complainType)) {
                                if (diff - fType1 < 0) {
                                    timelyCompletionRateInt ++;
                                }
                            } else if ("2".equals(complainType)) {
                                if (diff - fType2 < 0) {
                                    timelyCompletionRateInt ++;
                                }
                            } else if ("3".equals(complainType)) {
                                if (diff - fType3 < 0) {
                                    timelyCompletionRateInt ++;
                                }
                            }
                        }
                    }

                    if (timelyCompletionRateInt > 0) {
                        BigDecimal CompletionRateIntDecimal = new BigDecimal(timelyCompletionRateInt);

                        BigDecimal divide = CompletionRateIntDecimal.multiply(new BigDecimal(100)).divide(count, 2, BigDecimal.ROUND_HALF_UP);

                        //统计 及时办结率
                        totalTimelyCompletionRate = totalTimelyCompletionRate.add(CompletionRateIntDecimal);

                        complainDealSummaryAnalysisTableVo1.setTimelyCompletionRate(divide.toString());
                    } else {
                        complainDealSummaryAnalysisTableVo1.setTimelyCompletionRate("0");
                    }
                }
                // 如果没有发生量则别的都是0
            } else {
                complainDealSummaryAnalysisTableVo1.setCompletionRate("0");
                complainDealSummaryAnalysisTableVo1.setTimelyCompletionRate("0");
            }

            complainDealSummaryAnalysisTableVos.add(complainDealSummaryAnalysisTableVo1);
        }
        // 如果有数据，则往 empty集合里面放值
        if (complainDealSummaryAnalysisTableVos.size() > 0) {
            for (int i = 0; i < complainDealSummaryAnalysisTableVosEmpty.size(); i++) {
                ComplainDealSummaryAnalysisTableVo dealSummaryAnalysisTableVo = complainDealSummaryAnalysisTableVosEmpty.get(i);
                for (ComplainDealSummaryAnalysisTableVo summaryAnalysisTableVo : complainDealSummaryAnalysisTableVos) {
                    if (dealSummaryAnalysisTableVo.getDate().equals(summaryAnalysisTableVo.getDate())) {
                        dealSummaryAnalysisTableVo.setAmount(summaryAnalysisTableVo.getAmount());
                        dealSummaryAnalysisTableVo.setCompletionRate(summaryAnalysisTableVo.getCompletionRate());
                        dealSummaryAnalysisTableVo.setTimelyCompletionRate(summaryAnalysisTableVo.getTimelyCompletionRate());
                    }
                }

                //说明是 统计
                if (i == 12 ) {
                    dealSummaryAnalysisTableVo.setAmount(totalAmount.toString());

                    // 统计 办结率
                    BigDecimal divide = totalCompletionRate.multiply(new BigDecimal(100)).divide(totalAmount, 2, BigDecimal.ROUND_HALF_UP);
                    dealSummaryAnalysisTableVo.setCompletionRate(divide.toString());

                    // 统计 及时办结率
                    BigDecimal divide1 = totalTimelyCompletionRate.multiply(new BigDecimal(100)).divide(totalAmount, 2, BigDecimal.ROUND_HALF_UP);
                    dealSummaryAnalysisTableVo.setTimelyCompletionRate(divide1.toString());
                }
            }
        }
        return complainDealSummaryAnalysisTableVosEmpty;
    }


}
