package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TCityLevelRegionMapper;
import com.zehong.system.domain.TCityLevelRegion;
import com.zehong.system.service.ITCityLevelRegionService;

/**
 * 市级行政区Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-06
 */
@Service
public class TCityLevelRegionServiceImpl implements ITCityLevelRegionService 
{
    @Autowired
    private TCityLevelRegionMapper tCityLevelRegionMapper;

    /**
     * 查询市级行政区
     * 
     * @param fId 市级行政区ID
     * @return 市级行政区
     */
    @Override
    public TCityLevelRegion selectTCityLevelRegionById(Long fId)
    {
        return tCityLevelRegionMapper.selectTCityLevelRegionById(fId);
    }

    /**
     * 查询市级行政区列表
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 市级行政区
     */
    @Override
    public List<TCityLevelRegion> selectTCityLevelRegionList(TCityLevelRegion tCityLevelRegion)
    {
        return tCityLevelRegionMapper.selectTCityLevelRegionList(tCityLevelRegion);
    }

    /**
     * 新增市级行政区
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 结果
     */
    @Override
    public int insertTCityLevelRegion(TCityLevelRegion tCityLevelRegion)
    {
        return tCityLevelRegionMapper.insertTCityLevelRegion(tCityLevelRegion);
    }

    /**
     * 修改市级行政区
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 结果
     */
    @Override
    public int updateTCityLevelRegion(TCityLevelRegion tCityLevelRegion)
    {
        return tCityLevelRegionMapper.updateTCityLevelRegion(tCityLevelRegion);
    }

    /**
     * 批量删除市级行政区
     * 
     * @param fIds 需要删除的市级行政区ID
     * @return 结果
     */
    @Override
    public int deleteTCityLevelRegionByIds(Long[] fIds)
    {
        return tCityLevelRegionMapper.deleteTCityLevelRegionByIds(fIds);
    }

    /**
     * 删除市级行政区信息
     * 
     * @param fId 市级行政区ID
     * @return 结果
     */
    @Override
    public int deleteTCityLevelRegionById(Long fId)
    {
        return tCityLevelRegionMapper.deleteTCityLevelRegionById(fId);
    }
}
