package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.GovernmentDataCopyUtil;
import com.zehong.common.utils.GovernmentDataUtil;
import com.zehong.system.domain.FProBehInfor;
import com.zehong.system.domain.vo.ProAppInfoVo;
import com.zehong.system.domain.vo.ProBehInfoVo;
import com.zehong.system.mapper.FProBehInforMapper;
import com.zehong.system.service.IFProBehInforService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 行业专家库-专家行为申报Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-09
 */
@Service
public class FProBehInforServiceImpl implements IFProBehInforService 
{

    private static final Logger log = LoggerFactory.getLogger(FProBehInforServiceImpl.class);

    @Autowired
    private FProBehInforMapper fProBehInforMapper;

    @Resource
    private GovernmentDataUtil governmentDataUtil;

    /**
     * 查询行业专家库-专家行为申报
     * 
     * @param fProBehInforId 行业专家库-专家行为申报ID
     * @return 行业专家库-专家行为申报
     */
    @Override
    public FProBehInfor selectFProBehInforById(Long fProBehInforId)
    {
        return fProBehInforMapper.selectFProBehInforById(fProBehInforId);
    }

    /**
     * 查询行业专家库-专家行为申报列表
     * 
     * @param fProBehInfor 行业专家库-专家行为申报
     * @return 行业专家库-专家行为申报
     */
    @Override
    public List<FProBehInfor> selectFProBehInforList(FProBehInfor fProBehInfor)
    {
        return fProBehInforMapper.selectFProBehInforList(fProBehInfor);
    }

    /**
     * 新增行业专家库-专家行为申报
     * 
     * @param fProBehInfor 行业专家库-专家行为申报
     * @return 结果
     */
    @Override
    public int insertFProBehInfor(FProBehInfor fProBehInfor){
        fProBehInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return fProBehInforMapper.insertFProBehInfor(fProBehInfor);
    }

    /**
     * 修改行业专家库-专家行为申报
     * 
     * @param fProBehInfor 行业专家库-专家行为申报
     * @return 结果
     */
    @Override
    public int updateFProBehInfor(FProBehInfor fProBehInfor){
        fProBehInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return fProBehInforMapper.updateFProBehInfor(fProBehInfor);
    }

    /**
     * 批量删除行业专家库-专家行为申报
     * 
     * @param fProBehInforIds 需要删除的行业专家库-专家行为申报ID
     * @return 结果
     */
    @Override
    public int deleteFProBehInforByIds(Long[] fProBehInforIds)
    {
        return fProBehInforMapper.deleteFProBehInforByIds(fProBehInforIds);
    }

    /**
     * 删除行业专家库-专家行为申报信息
     * 
     * @param fProBehInforId 行业专家库-专家行为申报ID
     * @return 结果
     */
    @Override
    public int deleteFProBehInforById(Long fProBehInforId)
    {
        return fProBehInforMapper.deleteFProBehInforById(fProBehInforId);
    }

    /**
     * 专家申报
     * @param fProBehInforId 专家行为主键
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int reportProBehInfo(Long fProBehInforId) throws Exception{
        FProBehInfor updateInfo = new FProBehInfor();
        updateInfo.setfProBehInforId(fProBehInforId);
        updateInfo.setfRepStatus(Long.parseLong("1"));
        updateInfo.setfRepDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        int result = fProBehInforMapper.updateFProBehInfor(updateInfo);
        FProBehInfor behInfor = fProBehInforMapper.selectFProBehInforById(fProBehInforId);
        ProBehInfoVo proBehInfoVo = new ProBehInfoVo();
        GovernmentDataCopyUtil.copyToGovernData(behInfor,proBehInfoVo);
        List<ProBehInfoVo> data = new ArrayList<>();
        data.add(proBehInfoVo);
        JSONObject reportResult = governmentDataUtil.setInfo("professor/behaviour/information","WRITE",data);
        log.info("专家行为申报结果===================" + reportResult.toJSONString());
        if(!"0".equals(reportResult.getString("resultCode"))) throw new CustomException("专家行为上报市局接口失败");
        return result;
    }
}
