package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.FProBehInforBrowseMapper;
import com.zehong.system.domain.FProBehInforBrowse;
import com.zehong.system.service.IFProBehInforBrowseService;

/**
 * 行业专家库-专家行为浏览Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-09
 */
@Service
public class FProBehInforBrowseServiceImpl implements IFProBehInforBrowseService 
{
    @Autowired
    private FProBehInforBrowseMapper fProBehInforBrowseMapper;

    /**
     * 查询行业专家库-专家行为浏览
     * 
     * @param fProBehInforId 行业专家库-专家行为浏览ID
     * @return 行业专家库-专家行为浏览
     */
    @Override
    public FProBehInforBrowse selectFProBehInforBrowseById(Long fProBehInforId)
    {
        return fProBehInforBrowseMapper.selectFProBehInforBrowseById(fProBehInforId);
    }

    /**
     * 查询行业专家库-专家行为浏览列表
     * 
     * @param fProBehInforBrowse 行业专家库-专家行为浏览
     * @return 行业专家库-专家行为浏览
     */
    @Override
    public List<FProBehInforBrowse> selectFProBehInforBrowseList(FProBehInforBrowse fProBehInforBrowse)
    {
        return fProBehInforBrowseMapper.selectFProBehInforBrowseList(fProBehInforBrowse);
    }

    /**
     * 新增行业专家库-专家行为浏览
     * 
     * @param fProBehInforBrowse 行业专家库-专家行为浏览
     * @return 结果
     */
    @Override
    public int insertFProBehInforBrowse(FProBehInforBrowse fProBehInforBrowse)
    {
        return fProBehInforBrowseMapper.insertFProBehInforBrowse(fProBehInforBrowse);
    }

    /**
     * 修改行业专家库-专家行为浏览
     * 
     * @param fProBehInforBrowse 行业专家库-专家行为浏览
     * @return 结果
     */
    @Override
    public int updateFProBehInforBrowse(FProBehInforBrowse fProBehInforBrowse)
    {
        return fProBehInforBrowseMapper.updateFProBehInforBrowse(fProBehInforBrowse);
    }

    /**
     * 批量删除行业专家库-专家行为浏览
     * 
     * @param fProBehInforIds 需要删除的行业专家库-专家行为浏览ID
     * @return 结果
     */
    @Override
    public int deleteFProBehInforBrowseByIds(Long[] fProBehInforIds)
    {
        return fProBehInforBrowseMapper.deleteFProBehInforBrowseByIds(fProBehInforIds);
    }

    /**
     * 删除行业专家库-专家行为浏览信息
     * 
     * @param fProBehInforId 行业专家库-专家行为浏览ID
     * @return 结果
     */
    @Override
    public int deleteFProBehInforBrowseById(Long fProBehInforId)
    {
        return fProBehInforBrowseMapper.deleteFProBehInforBrowseById(fProBehInforId);
    }
}
