package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TVideoManager;

/**
 * 视频管理Service接口
 * 
 * @author zehong
 * @date 2022-02-15
 */
public interface ITVideoManagerService 
{
    /**
     * 查询视频管理
     * 
     * @param videoManagerId 视频管理ID
     * @return 视频管理
     */
    public TVideoManager selectTVideoManagerById(Long videoManagerId);

    /**
     * 查询视频管理列表
     * 
     * @param tVideoManager 视频管理
     * @return 视频管理集合
     */
    public List<TVideoManager> selectTVideoManagerList(TVideoManager tVideoManager);

    /**
     * 新增视频管理
     * 
     * @param tVideoManager 视频管理
     * @return 结果
     */
    public int insertTVideoManager(TVideoManager tVideoManager);

    /**
     * 修改视频管理
     * 
     * @param tVideoManager 视频管理
     * @return 结果
     */
    public int updateTVideoManager(TVideoManager tVideoManager);

    /**
     * 批量删除视频管理
     * 
     * @param videoManagerIds 需要删除的视频管理ID
     * @return 结果
     */
    public int deleteTVideoManagerByIds(Long[] videoManagerIds);

    /**
     * 删除视频管理信息
     * 
     * @param videoManagerId 视频管理ID
     * @return 结果
     */
    public int deleteTVideoManagerById(Long videoManagerId);
}
