package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TUserManageVillage;

/**
 * 基本信息维护-用户管理-居住区(村庄)Service接口
 * 
 * @author zehong
 * @date 2024-08-27
 */
public interface ITUserManageVillageService 
{
    /**
     * 查询基本信息维护-用户管理-居住区(村庄)
     * 
     * @param fVillageId 基本信息维护-用户管理-居住区(村庄)ID
     * @return 基本信息维护-用户管理-居住区(村庄)
     */
    public TUserManageVillage selectTUserManageVillageById(Long fVillageId);

    /**
     * 查询基本信息维护-用户管理-居住区(村庄)列表
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 基本信息维护-用户管理-居住区(村庄)集合
     */
    public List<TUserManageVillage> selectTUserManageVillageList(TUserManageVillage tUserManageVillage);

    /**
     * 提供给第三方使用的 分页查询
     * @param pageNum p
     * @param pageSize p
     * @return r
     */
    public List<TUserManageVillage> queryUserManageVillageForThirdParty(Integer pageNum,Integer pageSize);

    /**
     * 查询基本信息维护-用户管理-居住区(村庄)列表
     *
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 基本信息维护-用户管理-居住区(村庄)集合
     */
    public List<TUserManageVillage> exportTUserManageVillageList(TUserManageVillage tUserManageVillage);

    /**
     * 根据 名称集合查询 村列表
     * @param villageNames v
     * @return r
     */
    public List<TUserManageVillage> queryByVillageNames(List<String> villageNames);

    /**
     * 根据 id集合查询
     * @param villageIds v
     * @return r
     */
    public List<TUserManageVillage> queryByVillageIds(List<Long> villageIds);
    /**
     * 新增基本信息维护-用户管理-居住区(村庄)
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 结果
     */
    public int insertTUserManageVillage(TUserManageVillage tUserManageVillage);

    /**
     * 批量插入
     * @param userManageVillages s
     * @return r
     */
    public int insertBatch(List<TUserManageVillage> userManageVillages);

    /**
     * 修改基本信息维护-用户管理-居住区(村庄)
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 结果
     */
    public int updateTUserManageVillage(TUserManageVillage tUserManageVillage);

    /**
     * 批量删除基本信息维护-用户管理-居住区(村庄)
     * 
     * @param fVillageIds 需要删除的基本信息维护-用户管理-居住区(村庄)ID
     * @return 结果
     */
    public int deleteTUserManageVillageByIds(Long[] fVillageIds);

    /**
     * 删除基本信息维护-用户管理-居住区(村庄)信息
     * 
     * @param fVillageId 基本信息维护-用户管理-居住区(村庄)ID
     * @return 结果
     */
    public int deleteTUserManageVillageById(Long fVillageId);
}
