package com.zehong.system.service;

import java.util.List;

import com.zehong.system.domain.Statistics;
import com.zehong.system.domain.TSupBalGasSup;

/**
 * 供需平衡-气量监管Service接口
 * 
 * @author zehong
 * @date 2024-06-15
 */
public interface ITSupBalGasSupService 
{
    /**
     * 查询供需平衡-气量监管
     * 
     * @param fGasSupId 供需平衡-气量监管ID
     * @return 供需平衡-气量监管
     */
    public TSupBalGasSup selectTSupBalGasSupById(Long fGasSupId);

    /**
     * 查询供需平衡-气量监管列表
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 供需平衡-气量监管集合
     */
    public List<TSupBalGasSup> selectTSupBalGasSupList(TSupBalGasSup tSupBalGasSup);

    /**
     *
     * @param sevenDate s
     * @return
     */
    public List<Statistics> tSupBalGasSupStatistics(List<String> sevenDate);


    /**
     * 新增供需平衡-气量监管
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 结果
     */
    public int insertTSupBalGasSup(TSupBalGasSup tSupBalGasSup);

    /**
     * 修改供需平衡-气量监管
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 结果
     */
    public int updateTSupBalGasSup(TSupBalGasSup tSupBalGasSup);

    /**
     * 批量删除供需平衡-气量监管
     * 
     * @param fGasSupIds 需要删除的供需平衡-气量监管ID
     * @return 结果
     */
    public int deleteTSupBalGasSupByIds(Long[] fGasSupIds);

    /**
     * 删除供需平衡-气量监管信息
     * 
     * @param fGasSupId 供需平衡-气量监管ID
     * @return 结果
     */
    public int deleteTSupBalGasSupById(Long fGasSupId);

    /**
     * 获取上报信息
     * @param companyId 企业id
     * @param calendarDate 上报时间
     * @return
     */
    TSupBalGasSup getReportInfoByCompany(String companyId, String calendarDate);

    /**
     * 上传气量监管记录
     * @param fGasSupId 监管记录主键
     * @return
     */
    int reportSupBalGasSupRecInfo(Long fGasSupId);
}
