package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TSerialNumberInfo;

/**
 * 序列号Service接口
 * 
 * @author zehong
 * @date 2024-06-07
 */
public interface ITSerialNumberInfoService 
{
    /**
     * 查询序列号
     * 
     * @param numberId 序列号ID
     * @return 序列号
     */
    public TSerialNumberInfo selectTSerialNumberInfoById(Long numberId);

    /**
     * 查询序列号列表
     * 
     * @param tSerialNumberInfo 序列号
     * @return 序列号集合
     */
    public List<TSerialNumberInfo> selectTSerialNumberInfoList(TSerialNumberInfo tSerialNumberInfo);

    /**
     * 新增序列号
     * 
     * @param tSerialNumberInfo 序列号
     * @return 结果
     */
    public int insertTSerialNumberInfo(TSerialNumberInfo tSerialNumberInfo);

    /**
     * 修改序列号
     * 
     * @param tSerialNumberInfo 序列号
     * @return 结果
     */
    public int updateTSerialNumberInfo(TSerialNumberInfo tSerialNumberInfo);

    /**
     * 批量删除序列号
     * 
     * @param numberIds 需要删除的序列号ID
     * @return 结果
     */
    public int deleteTSerialNumberInfoByIds(Long[] numberIds);

    /**
     * 删除序列号信息
     * 
     * @param numberId 序列号ID
     * @return 结果
     */
    public int deleteTSerialNumberInfoById(Long numberId);

    /**
     * 根据表类型获取序列号
     * @param tableType 表表类型
     * @return
     */
    Map<String,String> getSerialNumberByTableType(String tableType);
}
