package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSecurityDisseminate;

/**
 * 安全宣传Service接口
 * 
 * @author zehong
 * @date 2024-04-22
 */
public interface ITSecurityDisseminateService 
{
    /**
     * 查询安全宣传
     * 
     * @param securityId 安全宣传ID
     * @return 安全宣传
     */
    public TSecurityDisseminate selectTSecurityDisseminateById(Long securityId);

    /**
     * 查询安全宣传列表
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 安全宣传集合
     */
    public List<TSecurityDisseminate> selectTSecurityDisseminateList(TSecurityDisseminate tSecurityDisseminate);

    /**
     * 新增安全宣传
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 结果
     */
    public int insertTSecurityDisseminate(TSecurityDisseminate tSecurityDisseminate);

    /**
     * 修改安全宣传
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 结果
     */
    public int updateTSecurityDisseminate(TSecurityDisseminate tSecurityDisseminate);

    /**
     * 批量删除安全宣传
     * 
     * @param securityIds 需要删除的安全宣传ID
     * @return 结果
     */
    public int deleteTSecurityDisseminateByIds(Long[] securityIds);

    /**
     * 删除安全宣传信息
     * 
     * @param securityId 安全宣传ID
     * @return 结果
     */
    public int deleteTSecurityDisseminateById(Long securityId);
}
