package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TRiskDevMajInfor;

/**
 * 重要风险点管控Service接口
 * 
 * @author zehong
 * @date 2024-07-01
 */
public interface ITRiskDevMajInforService 
{
    /**
     * 查询重要风险点管控
     * 
     * @param fRiskDevMajInforId 重要风险点管控ID
     * @return 重要风险点管控
     */
    public TRiskDevMajInfor selectTRiskDevMajInforById(Long fRiskDevMajInforId);


    /**
     * 查询重要风险点管控
     *
     * @param fRiskDevMajInforId 重要风险点管控ID - 详情用
     * @return 重要风险点管控
     */
    public TRiskDevMajInfor selectTRiskDevMajInforByIdForDetail(Long fRiskDevMajInforId);

    /**
     * 查询重要风险点管控列表
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 重要风险点管控集合
     */
    public List<TRiskDevMajInfor> selectTRiskDevMajInforList(TRiskDevMajInfor tRiskDevMajInfor);

    /**
     * 查询重要风险点管控列表 - 导出用
     *
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 重要风险点管控集合
     */
    List<TRiskDevMajInfor> exportRiskDevMajInforList(TRiskDevMajInfor tRiskDevMajInfor);
    /**
     * 新增重要风险点管控
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 结果
     */
    public int insertTRiskDevMajInfor(TRiskDevMajInfor tRiskDevMajInfor);

    /**
     * 修改重要风险点管控
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 结果
     */
    public int updateTRiskDevMajInfor(TRiskDevMajInfor tRiskDevMajInfor);

    /**
     * 批量删除重要风险点管控
     * 
     * @param fRiskDevMajInforIds 需要删除的重要风险点管控ID
     * @return 结果
     */
    public int deleteTRiskDevMajInforByIds(Long[] fRiskDevMajInforIds);

    /**
     * 删除重要风险点管控信息
     * 
     * @param fRiskDevMajInforId 重要风险点管控ID
     * @return 结果
     */
    public int deleteTRiskDevMajInforById(Long fRiskDevMajInforId);

    /**
     * 上传重要风险点档案
     * @param fRiskDevMajInforId 重要风险点档案id
     * @return
     */
    int reportRiskInfo(Long fRiskDevMajInforId) throws Exception;


    /**
     * 企业端-上传重要风险点档案
     * @param fRiskDevMajInforId 重要风险点档案id
     * @return
     */
    int entReportRiskInfo(Long fRiskDevMajInforId) ;
}
