package com.zehong.system.service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TProjectInfo;

/**
 * 工程项目信息Service接口
 *
 * @author zehong
 * @date 2022-03-16
 */
public interface ITProjectInfoService
{
    /**
     * 查询工程项目信息
     *
     * @param projectId 工程项目信息ID
     * @return 工程项目信息
     */
    public TProjectInfo selectTProjectInfoById(Long projectId);

    /**
     * 查询工程项目信息列表
     *
     * @param tProjectInfo 工程项目信息
     * @return 工程项目信息集合
     */
    public List<TProjectInfo> selectTProjectInfoList(TProjectInfo tProjectInfo);

    /**
     * 新增工程项目信息
     *
     * @param tProjectInfo 工程项目信息
     * @return 结果
     */
    public int insertTProjectInfo(TProjectInfo tProjectInfo);

    /**
     * 修改工程项目信息
     *
     * @param tProjectInfo 工程项目信息
     * @return 结果
     */
    public int updateTProjectInfo(TProjectInfo tProjectInfo);

    /**
     * 批量删除工程项目信息
     *
     * @param projectIds 需要删除的工程项目信息ID
     * @return 结果
     */
    public int deleteTProjectInfoByIds(Long[] projectIds);

    /**
     * 删除工程项目信息信息
     *
     * @param projectId 工程项目信息ID
     * @return 结果
     */
    public int deleteTProjectInfoById(Long projectId);

    /**
     * 查询是否已经有重复的年份数据
     * @param projectYear
     * @return
     */
    List<TProjectInfo> selectSameYear(Date projectYear,String beyondEnterpriseId);

    /**
     * 重复年份删除方法
     * @param isSameYear
     */
    void deleteisSameYear(Date isSameYear,String beyondEnterpriseId);

    /**
     * 查询修改文件之前的路径
     * @param projectId
     */
    TProjectInfo selectNearbyAddress(Long projectId);

    /**
     * 查询企业名称
     * @param deptId
     * @return
     */
    String selectEnterpriseName(String deptId);

    Map<String,Object> selectNum();
}
