package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TPipeOldPlanProcess;

/**
 * 老旧管网-改造计划和进度Service接口
 * 
 * @author zehong
 * @date 2024-06-15
 */
public interface ITPipeOldPlanProcessService 
{
    /**
     * 查询老旧管网-改造计划和进度
     * 
     * @param fOldPlanProcessId 老旧管网-改造计划和进度ID
     * @return 老旧管网-改造计划和进度
     */
    public TPipeOldPlanProcess selectTPipeOldPlanProcessById(Long fOldPlanProcessId);

    /**
     * 查询老旧管网-改造计划和进度列表
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 老旧管网-改造计划和进度集合
     */
    public List<TPipeOldPlanProcess> selectTPipeOldPlanProcessList(TPipeOldPlanProcess tPipeOldPlanProcess);

    /**
     * 查询 导出使用
     * @param tPipeOldPlanProcess t
     * @return r
     */
    public List<TPipeOldPlanProcess> exportTPipeOldPlanProcessList(TPipeOldPlanProcess tPipeOldPlanProcess);

    /**
     * 新增老旧管网-改造计划和进度
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 结果
     */
    public int insertTPipeOldPlanProcess(TPipeOldPlanProcess tPipeOldPlanProcess);

    /**
     * 修改老旧管网-改造计划和进度
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 结果
     */
    public int updateTPipeOldPlanProcess(TPipeOldPlanProcess tPipeOldPlanProcess);

    /**
     * 批量删除老旧管网-改造计划和进度
     * 
     * @param fOldPlanProcessIds 需要删除的老旧管网-改造计划和进度ID
     * @return 结果
     */
    public int deleteTPipeOldPlanProcessByIds(Long[] fOldPlanProcessIds);

    /**
     * 删除老旧管网-改造计划和进度信息
     * 
     * @param fOldPlanProcessId 老旧管网-改造计划和进度ID
     * @return 结果
     */
    public int deleteTPipeOldPlanProcessById(Long fOldPlanProcessId);

    /**
     * 上传计划和进度
     * @param fOldPlanProcessId 计划id
     * @return
     */
    int reportPipeOldPlanProcess(Long fOldPlanProcessId) throws Exception;

    /**
     * 企业端上传 计划
     * @param fOldPlanProcessId f
     * @return r
     */
    int entReportPipeOldPlanProcess(Long fOldPlanProcessId);
}
