package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TPatrolPosition;

/**
 * 巡检点Service接口
 * 
 * @author zehong
 * @date 2023-08-05
 */
public interface ITPatrolPositionService 
{
    /**
     * 查询巡检点
     * 
     * @param patrolId 巡检点ID
     * @return 巡检点
     */
    public TPatrolPosition selectTPatrolPositionById(Long patrolId);

    /**
     * 查询巡检点列表
     * 
     * @param tPatrolPosition 巡检点
     * @return 巡检点集合
     */
    public List<TPatrolPosition> selectTPatrolPositionList(TPatrolPosition tPatrolPosition);

    /**
     * 新增巡检点
     * 
     * @param tPatrolPosition 巡检点
     * @return 结果
     */
    public int insertTPatrolPosition(TPatrolPosition tPatrolPosition);

    /**
     * 修改巡检点
     * 
     * @param tPatrolPosition 巡检点
     * @return 结果
     */
    public int updateTPatrolPosition(TPatrolPosition tPatrolPosition);

    /**
     * 批量删除巡检点
     * 
     * @param patrolIds 需要删除的巡检点ID
     * @return 结果
     */
    public int deleteTPatrolPositionByIds(Long[] patrolIds);

    /**
     * 删除巡检点信息
     * 
     * @param patrolId 巡检点ID
     * @return 结果
     */
    public int deleteTPatrolPositionById(Long patrolId);
}
