package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.TLpgGasBottleFiles;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油气-气瓶档案Service接口
 * 
 * @author zehong
 * @date 2024-07-09
 */
public interface ITLpgGasBottleFilesService 
{
    /**
     * 查询液化石油气-气瓶档案
     * 
     * @param fGasBottleFilesId 液化石油气-气瓶档案ID
     * @return 液化石油气-气瓶档案
     */
    public TLpgGasBottleFiles selectTLpgGasBottleFilesById(Long fGasBottleFilesId);

    /**
     * 查询液化石油气-气瓶档案列表
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 液化石油气-气瓶档案集合
     */
    public List<TLpgGasBottleFiles> selectTLpgGasBottleFilesList(TLpgGasBottleFiles tLpgGasBottleFiles);

    /**
     * 导出查询
     * @param tLpgGasBottleFiles t
     * @return r
     */
    public List<TLpgGasBottleFiles> exportTLpgGasBottleFilesList(TLpgGasBottleFiles tLpgGasBottleFiles);
    /**
     * 新增液化石油气-气瓶档案
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 结果
     */
    public int insertTLpgGasBottleFiles(TLpgGasBottleFiles tLpgGasBottleFiles);

    /**
     * 修改液化石油气-气瓶档案
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 结果
     */
    public int updateTLpgGasBottleFiles(TLpgGasBottleFiles tLpgGasBottleFiles);

    /**
     * 批量删除液化石油气-气瓶档案
     * 
     * @param fGasBottleFilesIds 需要删除的液化石油气-气瓶档案ID
     * @return 结果
     */
    public int deleteTLpgGasBottleFilesByIds(Long[] fGasBottleFilesIds);

    /**
     * 删除液化石油气-气瓶档案信息
     * 
     * @param fGasBottleFilesId 液化石油气-气瓶档案ID
     * @return 结果
     */
    public int deleteTLpgGasBottleFilesById(Long fGasBottleFilesId);

    /**
     * 导入
     * @param xmbhList data
     * @param updateSupport 是否更新
     * @param response res
     * @return r
     */
    public AjaxResult importLpgGasBottleFilesInfo(List<TLpgGasBottleFiles> xmbhList, boolean updateSupport, HttpServletResponse response);


    /**
     * 第三方对接 新增数据
     * @param list l
     * @return r
     */
    public int externalDockingCreateLpgGasBottleFiles(List<TLpgGasBottleFiles> list);

    /**
     * 第三方对接 修改数据
     * @param list list
     * @return r
     */
    public int externalDockingUpdateLpgGasBottleFiles(List<TLpgGasBottleFiles> list);

    /**
     * 根据 气瓶条码集合 查询 气瓶集合
     * @param list l
     * @return r
     */
    public List<TLpgGasBottleFiles> queryALlByQrcodeList(List<String> list);

    /**
     * 根据 气瓶集合 和 企业id 查询数据
     * @param list list
     * @param enterpriseId e
     * @return r
     */
    public List<TLpgGasBottleFiles> queryAllByQrcodeAndEnterpriseList(@Param("list") List<String> list, @Param("enterpriseId") String enterpriseId);
}
