package com.zehong.system.service;

import java.util.HashMap;
import java.util.List;
import com.zehong.system.domain.TLpgDeliveryRecord;
import com.zehong.system.domain.vo.TLpgDeliveryRecordImportVo;
import com.zehong.system.domain.vo.UserManageGasUserExportVo;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油配送记录Service接口
 * 
 * @author zehong
 * @date 2024-07-22
 */
public interface ITLpgDeliveryRecordService 
{
    /**
     * 查询液化石油配送记录
     * 
     * @param deliveryRecordId 液化石油配送记录ID
     * @return 液化石油配送记录
     */
    public TLpgDeliveryRecord selectTLpgDeliveryRecordById(Long deliveryRecordId);

    /**
     * 配送记录数据
     *
     * @param XmbhList 用户数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param deptId 操作用户
     * @return 结果
     */
    public HashMap<String,Object> importLpgDelivertyRecordInfo(List<TLpgDeliveryRecordImportVo> XmbhList, Boolean isUpdateSupport, String deptId, HttpServletResponse response);


    /**
     * 查询液化石油配送记录列表
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 液化石油配送记录集合
     */
    public List<TLpgDeliveryRecord> selectTLpgDeliveryRecordList(TLpgDeliveryRecord tLpgDeliveryRecord);

    /**
     * 新增液化石油配送记录
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 结果
     */
    public int insertTLpgDeliveryRecord(TLpgDeliveryRecord tLpgDeliveryRecord);


    /**
     * 批量插入
     * @param tLpgDeliveryRecords t
     * @return r
     */
    public int insertBatch(List<TLpgDeliveryRecord> tLpgDeliveryRecords);

    /**
     * 修改液化石油配送记录
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 结果
     */
    public int updateTLpgDeliveryRecord(TLpgDeliveryRecord tLpgDeliveryRecord);

    /**
     * 批量删除液化石油配送记录
     * 
     * @param deliveryRecordIds 需要删除的液化石油配送记录ID
     * @return 结果
     */
    public int deleteTLpgDeliveryRecordByIds(Long[] deliveryRecordIds);

    /**
     * 删除液化石油配送记录信息
     * 
     * @param deliveryRecordId 液化石油配送记录ID
     * @return 结果
     */
    public int deleteTLpgDeliveryRecordById(Long deliveryRecordId);
}
