package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInsSpotHazardRef;

/**
 * 监督检查-抽查隐患Service接口
 * 
 * @author zehong
 * @date 2024-05-21
 */
public interface ITInsSpotHazardRefService 
{
    /**
     * 查询监督检查-抽查隐患
     * 
     * @param fInsSpotHazardRefId 监督检查-抽查隐患ID
     * @return 监督检查-抽查隐患
     */
    public TInsSpotHazardRef selectTInsSpotHazardRefById(Long fInsSpotHazardRefId);

    /**
     * 查询监督检查-抽查隐患列表
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 监督检查-抽查隐患集合
     */
    public List<TInsSpotHazardRef> selectTInsSpotHazardRefList(TInsSpotHazardRef tInsSpotHazardRef);

    /**
     * 新增监督检查-抽查隐患
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 结果
     */
    public int insertTInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef);

    /**
     * 修改监督检查-抽查隐患
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 结果
     */
    public int updateTInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef);

    /**
     * 抽查隐患-处置
     * @param tInsSpotHazardRef t
     * @return r
     */
    public int disposeOfInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef);

    /**
     * 批量删除监督检查-抽查隐患
     * 
     * @param fInsSpotHazardRefIds 需要删除的监督检查-抽查隐患ID
     * @return 结果
     */
    public int deleteTInsSpotHazardRefByIds(Long[] fInsSpotHazardRefIds);

    /**
     * 删除监督检查-抽查隐患信息
     * 
     * @param fInsSpotHazardRefId 监督检查-抽查隐患ID
     * @return 结果
     */
    public int deleteTInsSpotHazardRefById(Long fInsSpotHazardRefId);
}
