package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInsScopeInfor;

/**
 * 监督检查-检查范围Service接口
 * 
 * @author zehong
 * @date 2024-05-16
 */
public interface ITInsScopeInforService 
{
    /**
     * 查询监督检查-检查范围
     * 
     * @param fScopeInforId 监督检查-检查范围ID
     * @return 监督检查-检查范围
     */
    public TInsScopeInfor selectTInsScopeInforById(Long fScopeInforId);

    /**
     * 查询监督检查-检查范围列表
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 监督检查-检查范围集合
     */
    public List<TInsScopeInfor> selectTInsScopeInforList(TInsScopeInfor tInsScopeInfor);

    /**
     * 新增监督检查-检查范围
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 结果
     */
    public int insertTInsScopeInfor(TInsScopeInfor tInsScopeInfor);

    /**
     * 修改监督检查-检查范围
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 结果
     */
    public int updateTInsScopeInfor(TInsScopeInfor tInsScopeInfor);

    /**
     * 批量删除监督检查-检查范围
     * 
     * @param fScopeInforIds 需要删除的监督检查-检查范围ID
     * @return 结果
     */
    public int deleteTInsScopeInforByIds(Long[] fScopeInforIds);

    /**
     * 删除监督检查-检查范围信息
     * 
     * @param fScopeInforId 监督检查-检查范围ID
     * @return 结果
     */
    public int deleteTInsScopeInforById(Long fScopeInforId);
}
