package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmergencyDrills;

/**
 * 应急演练Service接口
 * 
 * @author zehong
 * @date 2024-04-19
 */
public interface ITEmergencyDrillsService 
{
    /**
     * 查询应急演练
     * 
     * @param fDrillsId 应急演练ID
     * @return 应急演练
     */
    public TEmergencyDrills selectTEmergencyDrillsById(Long fDrillsId);

    /**
     * 查询应急演练列表
     * 
     * @param tEmergencyDrills 应急演练
     * @return 应急演练集合
     */
    public List<TEmergencyDrills> selectTEmergencyDrillsList(TEmergencyDrills tEmergencyDrills);

    /**
     * 新增应急演练
     * 
     * @param tEmergencyDrills 应急演练
     * @return 结果
     */
    public int insertTEmergencyDrills(TEmergencyDrills tEmergencyDrills);

    /**
     * 修改应急演练
     * 
     * @param tEmergencyDrills 应急演练
     * @return 结果
     */
    public int updateTEmergencyDrills(TEmergencyDrills tEmergencyDrills);

    /**
     * 批量删除应急演练
     * 
     * @param fDrillsIds 需要删除的应急演练ID
     * @return 结果
     */
    public int deleteTEmergencyDrillsByIds(Long[] fDrillsIds);

    /**
     * 删除应急演练信息
     * 
     * @param fDrillsId 应急演练ID
     * @return 结果
     */
    public int deleteTEmergencyDrillsById(Long fDrillsId);
}
