package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDeviceUser;

/**
 * 设备用户Service接口
 * 
 * @author zehong
 * @date 2023-07-23
 */
public interface ITDeviceUserService 
{
    /**
     * 查询设备用户
     * 
     * @param userId 设备用户ID
     * @return 设备用户
     */
    public TDeviceUser selectTDeviceUserById(Long userId);
    public TDeviceUser selectTDeviceUserByCode(String code);

    /**
     * 查询设备用户列表
     * 
     * @param tDeviceUser 设备用户
     * @return 设备用户集合
     */
    public List<TDeviceUser> selectTDeviceUserList(TDeviceUser tDeviceUser);
    public List<TDeviceUser> allListbyTownship();


    /**
     * 新增设备用户
     * 
     * @param tDeviceUser 设备用户
     * @return 结果
     */
    public int insertTDeviceUser(TDeviceUser tDeviceUser);

    /**
     * 修改设备用户
     * 
     * @param tDeviceUser 设备用户
     * @return 结果
     */
    public int updateTDeviceUser(TDeviceUser tDeviceUser);

    /**
     * 批量删除设备用户
     * 
     * @param userIds 需要删除的设备用户ID
     * @return 结果
     */
    public int deleteTDeviceUserByIds(Long[] userIds);

    /**
     * 删除设备用户信息
     * 
     * @param userId 设备用户ID
     * @return 结果
     */
    public int deleteTDeviceUserById(Long userId);
}
