package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TConGasProInfor;

/**
 * 第三方施工-涉气第三方施工项目档案Service接口
 * 
 * @author zehong
 * @date 2024-06-26
 */
public interface ITConGasProInforService 
{
    /**
     * 查询第三方施工-涉气第三方施工项目档案
     * 
     * @param fConGasProInforId 第三方施工-涉气第三方施工项目档案ID
     * @return 第三方施工-涉气第三方施工项目档案
     */
    public TConGasProInfor selectTConGasProInforById(Long fConGasProInforId);

    /**
     * 查询第三方施工-涉气第三方施工项目档案列表
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 第三方施工-涉气第三方施工项目档案集合
     */
    public List<TConGasProInfor> selectTConGasProInforList(TConGasProInfor tConGasProInfor);

    /**
     * 查询第三方施工-涉气第三方施工项目档案列表-导出用
     *
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 第三方施工-涉气第三方施工项目档案集合
     */
    public List<TConGasProInfor> exportTConGasProInforList(TConGasProInfor tConGasProInfor);

    /**
     * 新增第三方施工-涉气第三方施工项目档案
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 结果
     */
    public int insertTConGasProInfor(TConGasProInfor tConGasProInfor);

    /**
     * 修改第三方施工-涉气第三方施工项目档案
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 结果
     */
    public int updateTConGasProInfor(TConGasProInfor tConGasProInfor);

    /**
     * 批量删除第三方施工-涉气第三方施工项目档案
     * 
     * @param fConGasProInforIds 需要删除的第三方施工-涉气第三方施工项目档案ID
     * @return 结果
     */
    public int deleteTConGasProInforByIds(Long[] fConGasProInforIds);

    /**
     * 删除第三方施工-涉气第三方施工项目档案信息
     * 
     * @param fConGasProInforId 第三方施工-涉气第三方施工项目档案ID
     * @return 结果
     */
    public int deleteTConGasProInforById(Long fConGasProInforId);

    /**
     * 上传第三方施工
     * @param fConGasProInforId 第三方施工id
     * @return
     */
    int reportConGasProInfo(Long fConGasProInforId) throws Exception;

    /**
     * 企业端上传数据
     * @param fConGasProInforId id
     * @return
     */
    int entReportConGasProInfo(Long fConGasProInforId);
}
