package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TConGasProInc;

/**
 * 第三方施工-涉气第三方施工意外事件Service接口
 * 
 * @author zehong
 * @date 2024-06-27
 */
public interface ITConGasProIncService 
{
    /**
     * 查询第三方施工-涉气第三方施工意外事件
     * 
     * @param fConGasProIncId 第三方施工-涉气第三方施工意外事件ID
     * @return 第三方施工-涉气第三方施工意外事件
     */
    public TConGasProInc selectTConGasProIncById(Long fConGasProIncId);

    /**
     * 查询第三方施工-涉气第三方施工意外事件列表
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 第三方施工-涉气第三方施工意外事件集合
     */
    public List<TConGasProInc> selectTConGasProIncList(TConGasProInc tConGasProInc);

    /**
     * 查询第三方施工-涉气第三方施工意外事件列表-导出
     *
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 第三方施工-涉气第三方施工意外事件集合
     */
    List<TConGasProInc> exportTConGasProIncList(TConGasProInc tConGasProInc);
    /**
     * 新增第三方施工-涉气第三方施工意外事件
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 结果
     */
    public int insertTConGasProInc(TConGasProInc tConGasProInc);

    /**
     * 修改第三方施工-涉气第三方施工意外事件
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 结果
     */
    public int updateTConGasProInc(TConGasProInc tConGasProInc);

    /**
     * 批量删除第三方施工-涉气第三方施工意外事件
     * 
     * @param fConGasProIncIds 需要删除的第三方施工-涉气第三方施工意外事件ID
     * @return 结果
     */
    public int deleteTConGasProIncByIds(Long[] fConGasProIncIds);

    /**
     * 删除第三方施工-涉气第三方施工意外事件信息
     * 
     * @param fConGasProIncId 第三方施工-涉气第三方施工意外事件ID
     * @return 结果
     */
    public int deleteTConGasProIncById(Long fConGasProIncId);

    /**
     * 上传第三方施工意外事件
     * @param fConGasProIncId 意外事件工id
     * @return
     */
    int reportAccidentInfo(Long fConGasProIncId) throws Exception ;

    /**
     * 企业端上传第三方施工意外事件
     * @param fConGasProIncId 意外事件工id
     * @return
     */
    int entReportConGasProInfo(Long fConGasProIncId);
}
